/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.internal.enforcing;

import de.quantummaid.eventmaid.internal.enforcing.InvalidInputException;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringValidator {
    private static final int MAXIMUM_LENGTH = 512;
    private static final Pattern SEVERAL_SPACES = Pattern.compile("\\s{2,}");

    public static String cleaned(String input) {
        String value = Optional.ofNullable(input).orElse("");
        if (value.length() > 512) {
            throw new InvalidInputException(String.format("Value is too long, max %s characters are allowed.", 512));
        }
        Matcher matcher = SEVERAL_SPACES.matcher(value);
        String singleWhiteSpaced = matcher.matches() ? matcher.replaceAll(" ") : value;
        String cleanString = singleWhiteSpaced.trim();
        return cleanString;
    }

    private StringValidator() {
    }
}

