/*
 * Copyright (c) 2020 Richard Hauswald - https://quantummaid.de/.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package de.quantummaid.eventmaid.useCases.useCaseAdapter.usecaseInstantiating;

/**
 * An {@link Exception} indicating an error, when creating a new instance of an use case with its zero arguments constructor.
 */
public final class ZeroArgumentsConstructorUseCaseInstantiatorException extends RuntimeException {

    private ZeroArgumentsConstructorUseCaseInstantiatorException(final String message, final Throwable cause) {
        super(message, cause);
    }

    static ZeroArgumentsConstructorUseCaseInstantiatorException zeroArgumentsConstructorUseCaseInstantiatorException(
            final Class<?> type, final Throwable cause) {
        return new ZeroArgumentsConstructorUseCaseInstantiatorException("Exception during instantiation " +
                "of " + type.getName() + " using zero argument constructor", cause);
    }
}
