/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.messageBus.statistics;

import java.math.BigInteger;
import java.util.Date;

public final class MessageBusStatistics {
    private final Date timestamp;
    private final BigInteger acceptedMessages;
    private final BigInteger successfulMessages;
    private final BigInteger failedMessages;
    private final BigInteger blockedMessages;
    private final BigInteger forgottenMessages;
    private final BigInteger queuedMessages;

    public static MessageBusStatistics messageBusStatistics(Date timestamp, BigInteger acceptedMessages, BigInteger successfulMessages, BigInteger failedMessages, BigInteger blockedMessages, BigInteger forgottenMessages, BigInteger queuedMessages) {
        return new MessageBusStatistics(timestamp, acceptedMessages, successfulMessages, failedMessages, blockedMessages, forgottenMessages, queuedMessages);
    }

    public Date getTimestamp() {
        long copyForSafeSharing = this.timestamp.getTime();
        return new Date(copyForSafeSharing);
    }

    public BigInteger getAcceptedMessages() {
        return this.acceptedMessages;
    }

    public BigInteger getSuccessfulMessages() {
        return this.successfulMessages;
    }

    public BigInteger getFailedMessages() {
        return this.failedMessages;
    }

    public BigInteger getBlockedMessages() {
        return this.blockedMessages;
    }

    public BigInteger getForgottenMessages() {
        return this.forgottenMessages;
    }

    public BigInteger getQueuedMessages() {
        return this.queuedMessages;
    }

    public String toString() {
        return "MessageBusStatistics(timestamp=" + this.getTimestamp() + ", acceptedMessages=" + this.getAcceptedMessages() + ", successfulMessages=" + this.getSuccessfulMessages() + ", failedMessages=" + this.getFailedMessages() + ", blockedMessages=" + this.getBlockedMessages() + ", forgottenMessages=" + this.getForgottenMessages() + ", queuedMessages=" + this.getQueuedMessages() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageBusStatistics)) {
            return false;
        }
        MessageBusStatistics other = (MessageBusStatistics)o;
        Date this$timestamp = this.getTimestamp();
        Date other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        BigInteger this$acceptedMessages = this.getAcceptedMessages();
        BigInteger other$acceptedMessages = other.getAcceptedMessages();
        if (this$acceptedMessages == null ? other$acceptedMessages != null : !((Object)this$acceptedMessages).equals(other$acceptedMessages)) {
            return false;
        }
        BigInteger this$successfulMessages = this.getSuccessfulMessages();
        BigInteger other$successfulMessages = other.getSuccessfulMessages();
        if (this$successfulMessages == null ? other$successfulMessages != null : !((Object)this$successfulMessages).equals(other$successfulMessages)) {
            return false;
        }
        BigInteger this$failedMessages = this.getFailedMessages();
        BigInteger other$failedMessages = other.getFailedMessages();
        if (this$failedMessages == null ? other$failedMessages != null : !((Object)this$failedMessages).equals(other$failedMessages)) {
            return false;
        }
        BigInteger this$blockedMessages = this.getBlockedMessages();
        BigInteger other$blockedMessages = other.getBlockedMessages();
        if (this$blockedMessages == null ? other$blockedMessages != null : !((Object)this$blockedMessages).equals(other$blockedMessages)) {
            return false;
        }
        BigInteger this$forgottenMessages = this.getForgottenMessages();
        BigInteger other$forgottenMessages = other.getForgottenMessages();
        if (this$forgottenMessages == null ? other$forgottenMessages != null : !((Object)this$forgottenMessages).equals(other$forgottenMessages)) {
            return false;
        }
        BigInteger this$queuedMessages = this.getQueuedMessages();
        BigInteger other$queuedMessages = other.getQueuedMessages();
        return !(this$queuedMessages == null ? other$queuedMessages != null : !((Object)this$queuedMessages).equals(other$queuedMessages));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Date $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        BigInteger $acceptedMessages = this.getAcceptedMessages();
        result = result * 59 + ($acceptedMessages == null ? 43 : ((Object)$acceptedMessages).hashCode());
        BigInteger $successfulMessages = this.getSuccessfulMessages();
        result = result * 59 + ($successfulMessages == null ? 43 : ((Object)$successfulMessages).hashCode());
        BigInteger $failedMessages = this.getFailedMessages();
        result = result * 59 + ($failedMessages == null ? 43 : ((Object)$failedMessages).hashCode());
        BigInteger $blockedMessages = this.getBlockedMessages();
        result = result * 59 + ($blockedMessages == null ? 43 : ((Object)$blockedMessages).hashCode());
        BigInteger $forgottenMessages = this.getForgottenMessages();
        result = result * 59 + ($forgottenMessages == null ? 43 : ((Object)$forgottenMessages).hashCode());
        BigInteger $queuedMessages = this.getQueuedMessages();
        result = result * 59 + ($queuedMessages == null ? 43 : ((Object)$queuedMessages).hashCode());
        return result;
    }

    private MessageBusStatistics(Date timestamp, BigInteger acceptedMessages, BigInteger successfulMessages, BigInteger failedMessages, BigInteger blockedMessages, BigInteger forgottenMessages, BigInteger queuedMessages) {
        this.timestamp = timestamp;
        this.acceptedMessages = acceptedMessages;
        this.successfulMessages = successfulMessages;
        this.failedMessages = failedMessages;
        this.blockedMessages = blockedMessages;
        this.forgottenMessages = forgottenMessages;
        this.queuedMessages = queuedMessages;
    }
}

