/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.configuration;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class AsynchronousConfiguration {
    public static final int DEFAULT_CORE_POOL_SIZE = 2;
    public static final int DEFAULT_MAXIMUM_POOL_SIZE = 2;
    public static final int DEFAULT_MAXIMUM_TIMEOUT = 60;
    public static final TimeUnit DEFAULT_TIMEUNIT = TimeUnit.SECONDS;
    public static final LinkedBlockingQueue<Runnable> DEFAULT_WORKING_QUEUE = new LinkedBlockingQueue();
    private int corePoolSize = 2;
    private int maximumPoolSize = 2;
    private int maximumTimeout = 60;
    private TimeUnit timeoutTimeUnit = DEFAULT_TIMEUNIT;
    private BlockingQueue<Runnable> threadPoolWorkingQueue = DEFAULT_WORKING_QUEUE;

    public AsynchronousConfiguration() {
    }

    public AsynchronousConfiguration(int corePoolSize, int maximumPoolSize, int maximumTimeout, TimeUnit timeoutTimeUnit, BlockingQueue<Runnable> threadPoolWorkingQueue) {
        this.corePoolSize = corePoolSize;
        this.maximumPoolSize = maximumPoolSize;
        this.maximumTimeout = maximumTimeout;
        this.timeoutTimeUnit = timeoutTimeUnit;
        this.threadPoolWorkingQueue = threadPoolWorkingQueue;
    }

    public static AsynchronousConfiguration constantPoolSizeAsynchronousConfiguration(int poolSize) {
        LinkedBlockingQueue<Runnable> threadPoolWorkingQueue = new LinkedBlockingQueue<Runnable>();
        return new AsynchronousConfiguration(poolSize, poolSize, Integer.MAX_VALUE, TimeUnit.SECONDS, threadPoolWorkingQueue);
    }

    public static AsynchronousConfiguration constantPoolSizeAsynchronousConfiguration(int poolSize, int waitingQueueBound) {
        ArrayBlockingQueue<Runnable> threadPoolWorkingQueue = new ArrayBlockingQueue<Runnable>(waitingQueueBound);
        return new AsynchronousConfiguration(poolSize, poolSize, Integer.MAX_VALUE, TimeUnit.SECONDS, threadPoolWorkingQueue);
    }

    public String toString() {
        return "AsynchronousConfiguration(corePoolSize=" + this.getCorePoolSize() + ", maximumPoolSize=" + this.getMaximumPoolSize() + ", maximumTimeout=" + this.getMaximumTimeout() + ", timeoutTimeUnit=" + this.getTimeoutTimeUnit() + ", threadPoolWorkingQueue=" + this.getThreadPoolWorkingQueue() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AsynchronousConfiguration)) {
            return false;
        }
        AsynchronousConfiguration other = (AsynchronousConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCorePoolSize() != other.getCorePoolSize()) {
            return false;
        }
        if (this.getMaximumPoolSize() != other.getMaximumPoolSize()) {
            return false;
        }
        if (this.getMaximumTimeout() != other.getMaximumTimeout()) {
            return false;
        }
        TimeUnit this$timeoutTimeUnit = this.getTimeoutTimeUnit();
        TimeUnit other$timeoutTimeUnit = other.getTimeoutTimeUnit();
        if (this$timeoutTimeUnit == null ? other$timeoutTimeUnit != null : !((Object)((Object)this$timeoutTimeUnit)).equals((Object)other$timeoutTimeUnit)) {
            return false;
        }
        BlockingQueue<Runnable> this$threadPoolWorkingQueue = this.getThreadPoolWorkingQueue();
        BlockingQueue<Runnable> other$threadPoolWorkingQueue = other.getThreadPoolWorkingQueue();
        return !(this$threadPoolWorkingQueue == null ? other$threadPoolWorkingQueue != null : !this$threadPoolWorkingQueue.equals(other$threadPoolWorkingQueue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AsynchronousConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCorePoolSize();
        result = result * 59 + this.getMaximumPoolSize();
        result = result * 59 + this.getMaximumTimeout();
        TimeUnit $timeoutTimeUnit = this.getTimeoutTimeUnit();
        result = result * 59 + ($timeoutTimeUnit == null ? 43 : ((Object)((Object)$timeoutTimeUnit)).hashCode());
        BlockingQueue<Runnable> $threadPoolWorkingQueue = this.getThreadPoolWorkingQueue();
        result = result * 59 + ($threadPoolWorkingQueue == null ? 43 : $threadPoolWorkingQueue.hashCode());
        return result;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public int getMaximumTimeout() {
        return this.maximumTimeout;
    }

    public void setMaximumTimeout(int maximumTimeout) {
        this.maximumTimeout = maximumTimeout;
    }

    public TimeUnit getTimeoutTimeUnit() {
        return this.timeoutTimeUnit;
    }

    public void setTimeoutTimeUnit(TimeUnit timeoutTimeUnit) {
        this.timeoutTimeUnit = timeoutTimeUnit;
    }

    public BlockingQueue<Runnable> getThreadPoolWorkingQueue() {
        return this.threadPoolWorkingQueue;
    }

    public void setThreadPoolWorkingQueue(BlockingQueue<Runnable> threadPoolWorkingQueue) {
        this.threadPoolWorkingQueue = threadPoolWorkingQueue;
    }
}

