/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.internal.pipe.transport;

import de.quantummaid.eventmaid.configuration.AsynchronousConfiguration;
import de.quantummaid.eventmaid.internal.pipe.PipeType;
import de.quantummaid.eventmaid.internal.pipe.error.PipeErrorHandler;
import de.quantummaid.eventmaid.internal.pipe.events.PipeEventListener;
import de.quantummaid.eventmaid.internal.pipe.transport.AsynchronousTransportMechanism;
import de.quantummaid.eventmaid.internal.pipe.transport.SynchronousDelivery;
import de.quantummaid.eventmaid.internal.pipe.transport.SynchronousTransportMechanism;
import de.quantummaid.eventmaid.internal.pipe.transport.TransportMechanism;
import de.quantummaid.eventmaid.subscribing.Subscriber;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class TransportMechanismFactory {
    public static <T> TransportMechanism<T> transportMechanism(PipeType pipeType, PipeEventListener<T> eventListener, PipeErrorHandler<T> errorHandler, List<Subscriber<T>> subscribers, AsynchronousConfiguration asynchronousConfiguration) {
        SynchronousDelivery<T> synchronousDelivery = new SynchronousDelivery<T>(eventListener, errorHandler);
        switch (pipeType) {
            case SYNCHRONOUS: {
                return new SynchronousTransportMechanism<T>(eventListener, synchronousDelivery, subscribers);
            }
            case ASYNCHRONOUS: {
                ThreadPoolExecutor threadPoolExecutor = TransportMechanismFactory.createThreadPoolExecutor(asynchronousConfiguration);
                return new AsynchronousTransportMechanism<T>(eventListener, synchronousDelivery, subscribers, threadPoolExecutor);
            }
        }
        throw new IllegalArgumentException("Unknown pipe type " + pipeType);
    }

    private static ThreadPoolExecutor createThreadPoolExecutor(AsynchronousConfiguration config) {
        int corePoolSize = config.getCorePoolSize();
        int maximumPoolSize = config.getMaximumPoolSize();
        int maximumTimeout = config.getMaximumTimeout();
        TimeUnit timeoutTimeUnit = config.getTimeoutTimeUnit();
        BlockingQueue<Runnable> queue = config.getThreadPoolWorkingQueue();
        return new ThreadPoolExecutor(corePoolSize, maximumPoolSize, maximumTimeout, timeoutTimeUnit, queue);
    }

    private TransportMechanismFactory() {
    }
}

