/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.useCases.useCaseAdapter;

import de.quantummaid.eventmaid.identification.CorrelationId;
import de.quantummaid.eventmaid.internal.enforcing.NotNullEnforcer;
import de.quantummaid.eventmaid.mapping.Deserializer;
import de.quantummaid.eventmaid.mapping.ExceptionSerializer;
import de.quantummaid.eventmaid.mapping.Serializer;
import de.quantummaid.eventmaid.processingContext.EventType;
import de.quantummaid.eventmaid.processingContext.ProcessingContext;
import de.quantummaid.eventmaid.serializedMessageBus.SerializedMessageBus;
import de.quantummaid.eventmaid.subscribing.AcceptingBehavior;
import de.quantummaid.eventmaid.subscribing.Subscriber;
import de.quantummaid.eventmaid.subscribing.SubscriptionId;
import de.quantummaid.eventmaid.useCases.useCaseAdapter.UseCaseCallingInformation;
import de.quantummaid.eventmaid.useCases.useCaseAdapter.UseCaseInvokingResponseEventType;
import de.quantummaid.eventmaid.useCases.useCaseAdapter.parameterInjecting.ParameterInjector;
import de.quantummaid.eventmaid.useCases.useCaseAdapter.usecaseCalling.Caller;
import de.quantummaid.eventmaid.useCases.useCaseAdapter.usecaseCalling.CallingContext;
import de.quantummaid.eventmaid.useCases.useCaseAdapter.usecaseInstantiating.UseCaseInstantiator;
import java.util.Map;

final class UseCaseRequestExecutingSubscriber
implements Subscriber<ProcessingContext<Map<String, Object>>> {
    private final UseCaseCallingInformation<?> useCaseCallingInformation;
    private final UseCaseInstantiator useCaseInstantiator;
    private final CallingContext callingContext;
    private final ExceptionSerializer exceptionSerializer;
    private final SubscriptionId subscriptionId = SubscriptionId.newUniqueId();
    private SerializedMessageBus serializedMessageBus;

    static UseCaseRequestExecutingSubscriber useCaseRequestExecutingSubscriber(UseCaseCallingInformation<?> useCaseCallingInformation, UseCaseInstantiator useCaseInstantiator, Deserializer requestDeserializer, Serializer responseSerializer, ExceptionSerializer exceptionSerializer, ParameterInjector parameterInjector) {
        NotNullEnforcer.ensureNotNull(useCaseCallingInformation, "useCaseCallingInformation");
        NotNullEnforcer.ensureNotNull(useCaseInstantiator, "useCaseInstantiator");
        NotNullEnforcer.ensureNotNull(requestDeserializer, "requestDeserializer");
        NotNullEnforcer.ensureNotNull(responseSerializer, "responseSerializer");
        NotNullEnforcer.ensureNotNull(exceptionSerializer, "exceptionSerializer");
        NotNullEnforcer.ensureNotNull(parameterInjector, "parameterInjector");
        CallingContext callingContext = CallingContext.callingContext(requestDeserializer, responseSerializer, parameterInjector);
        return new UseCaseRequestExecutingSubscriber(useCaseCallingInformation, useCaseInstantiator, callingContext, exceptionSerializer);
    }

    @Override
    public AcceptingBehavior accept(ProcessingContext<Map<String, Object>> processingContext) {
        Caller<?> caller = this.useCaseCallingInformation.getCaller();
        Class<?> useCaseClass = this.useCaseCallingInformation.getUseCaseClass();
        Object useCase = this.useCaseInstantiator.instantiate(useCaseClass);
        Map<String, Object> payload = processingContext.getPayload();
        Map<String, Object> serializedReturnValue = null;
        Map<String, Object> serializedException = null;
        try {
            serializedReturnValue = caller.call(useCase, payload, this.callingContext);
        }
        catch (Exception e) {
            serializedException = this.exceptionSerializer.serializeException(e);
        }
        CorrelationId correlationId = processingContext.generateCorrelationIdForAnswer();
        this.serializedMessageBus.send(UseCaseInvokingResponseEventType.USE_CASE_RESPONSE_EVENT_TYPE, serializedReturnValue, serializedException, correlationId);
        return AcceptingBehavior.MESSAGE_ACCEPTED;
    }

    @Override
    public SubscriptionId getSubscriptionId() {
        return this.subscriptionId;
    }

    public void attachTo(SerializedMessageBus serializedMessageBus) {
        this.serializedMessageBus = serializedMessageBus;
        EventType eventType = this.useCaseCallingInformation.getEventType();
        serializedMessageBus.subscribeRaw(eventType, this);
    }

    public String toString() {
        return "UseCaseRequestExecutingSubscriber(useCaseCallingInformation=" + this.useCaseCallingInformation + ", useCaseInstantiator=" + this.useCaseInstantiator + ", callingContext=" + this.callingContext + ", exceptionSerializer=" + this.exceptionSerializer + ", subscriptionId=" + this.getSubscriptionId() + ", serializedMessageBus=" + this.serializedMessageBus + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UseCaseRequestExecutingSubscriber)) {
            return false;
        }
        UseCaseRequestExecutingSubscriber other = (UseCaseRequestExecutingSubscriber)o;
        UseCaseCallingInformation<?> this$useCaseCallingInformation = this.useCaseCallingInformation;
        UseCaseCallingInformation<?> other$useCaseCallingInformation = other.useCaseCallingInformation;
        if (this$useCaseCallingInformation == null ? other$useCaseCallingInformation != null : !((Object)this$useCaseCallingInformation).equals(other$useCaseCallingInformation)) {
            return false;
        }
        UseCaseInstantiator this$useCaseInstantiator = this.useCaseInstantiator;
        UseCaseInstantiator other$useCaseInstantiator = other.useCaseInstantiator;
        if (this$useCaseInstantiator == null ? other$useCaseInstantiator != null : !this$useCaseInstantiator.equals(other$useCaseInstantiator)) {
            return false;
        }
        CallingContext this$callingContext = this.callingContext;
        CallingContext other$callingContext = other.callingContext;
        if (this$callingContext == null ? other$callingContext != null : !this$callingContext.equals(other$callingContext)) {
            return false;
        }
        ExceptionSerializer this$exceptionSerializer = this.exceptionSerializer;
        ExceptionSerializer other$exceptionSerializer = other.exceptionSerializer;
        if (this$exceptionSerializer == null ? other$exceptionSerializer != null : !this$exceptionSerializer.equals(other$exceptionSerializer)) {
            return false;
        }
        SubscriptionId this$subscriptionId = this.getSubscriptionId();
        SubscriptionId other$subscriptionId = other.getSubscriptionId();
        if (this$subscriptionId == null ? other$subscriptionId != null : !((Object)this$subscriptionId).equals(other$subscriptionId)) {
            return false;
        }
        SerializedMessageBus this$serializedMessageBus = this.serializedMessageBus;
        SerializedMessageBus other$serializedMessageBus = other.serializedMessageBus;
        return !(this$serializedMessageBus == null ? other$serializedMessageBus != null : !this$serializedMessageBus.equals(other$serializedMessageBus));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UseCaseCallingInformation<?> $useCaseCallingInformation = this.useCaseCallingInformation;
        result = result * 59 + ($useCaseCallingInformation == null ? 43 : ((Object)$useCaseCallingInformation).hashCode());
        UseCaseInstantiator $useCaseInstantiator = this.useCaseInstantiator;
        result = result * 59 + ($useCaseInstantiator == null ? 43 : $useCaseInstantiator.hashCode());
        CallingContext $callingContext = this.callingContext;
        result = result * 59 + ($callingContext == null ? 43 : $callingContext.hashCode());
        ExceptionSerializer $exceptionSerializer = this.exceptionSerializer;
        result = result * 59 + ($exceptionSerializer == null ? 43 : $exceptionSerializer.hashCode());
        SubscriptionId $subscriptionId = this.getSubscriptionId();
        result = result * 59 + ($subscriptionId == null ? 43 : ((Object)$subscriptionId).hashCode());
        SerializedMessageBus $serializedMessageBus = this.serializedMessageBus;
        result = result * 59 + ($serializedMessageBus == null ? 43 : $serializedMessageBus.hashCode());
        return result;
    }

    private UseCaseRequestExecutingSubscriber(UseCaseCallingInformation<?> useCaseCallingInformation, UseCaseInstantiator useCaseInstantiator, CallingContext callingContext, ExceptionSerializer exceptionSerializer) {
        this.useCaseCallingInformation = useCaseCallingInformation;
        this.useCaseInstantiator = useCaseInstantiator;
        this.callingContext = callingContext;
        this.exceptionSerializer = exceptionSerializer;
    }
}

