/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.serializedMessageBus;

import de.quantummaid.eventmaid.identification.CorrelationId;
import de.quantummaid.eventmaid.identification.MessageId;
import de.quantummaid.eventmaid.mapping.Deserializer;
import de.quantummaid.eventmaid.mapping.Serializer;
import de.quantummaid.eventmaid.messageBus.MessageBus;
import de.quantummaid.eventmaid.messageFunction.MessageFunction;
import de.quantummaid.eventmaid.messageFunction.MessageFunctionBuilder;
import de.quantummaid.eventmaid.messageFunction.ResponseFuture;
import de.quantummaid.eventmaid.processingContext.EventType;
import de.quantummaid.eventmaid.processingContext.ProcessingContext;
import de.quantummaid.eventmaid.serializedMessageBus.MissingErrorPayloadClassForDeserialization;
import de.quantummaid.eventmaid.serializedMessageBus.SerializedMessageBus;
import de.quantummaid.eventmaid.subscribing.AcceptingBehavior;
import de.quantummaid.eventmaid.subscribing.Subscriber;
import de.quantummaid.eventmaid.subscribing.SubscriptionId;
import de.quantummaid.eventmaid.useCases.payloadAndErrorPayload.PayloadAndErrorPayload;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SerializedMessageBusImpl
implements SerializedMessageBus {
    private final MessageBus messageBus;
    private final Serializer requestSerializer;
    private final Deserializer responseDeserializer;
    private final MessageFunction messageFunction;

    SerializedMessageBusImpl(MessageBus messageBus, Serializer requestSerializer, Deserializer responseDeserializer) {
        this.messageBus = messageBus;
        this.responseDeserializer = responseDeserializer;
        this.requestSerializer = requestSerializer;
        this.messageFunction = MessageFunctionBuilder.aMessageFunction(messageBus);
    }

    @Override
    public MessageId send(EventType eventType, Map<String, Object> data) {
        return this.messageBus.send(eventType, data);
    }

    @Override
    public MessageId send(EventType eventType, Map<String, Object> data, CorrelationId correlationId) {
        return this.messageBus.send(eventType, data, correlationId);
    }

    @Override
    public MessageId send(EventType eventType, Map<String, Object> data, Map<String, Object> errorData) {
        ProcessingContext<Object> processingContext = ProcessingContext.processingContextForPayloadAndError(eventType, data, errorData);
        return this.messageBus.send(processingContext);
    }

    @Override
    public MessageId send(EventType eventType, Map<String, Object> data, Map<String, Object> errorData, CorrelationId correlationId) {
        ProcessingContext<Object> processingContext = ProcessingContext.processingContextForPayloadAndError(eventType, correlationId, data, errorData);
        return this.messageBus.send(processingContext);
    }

    @Override
    public MessageId serializeAndSend(EventType eventType, Object data) {
        Map<String, Object> map = this.requestSerializer.serialize(data);
        return this.send(eventType, map);
    }

    @Override
    public MessageId serializeAndSend(EventType eventType, Object data, CorrelationId correlationId) {
        Map<String, Object> map = this.requestSerializer.serialize(data);
        return this.send(eventType, map, correlationId);
    }

    @Override
    public MessageId serializeAndSend(EventType eventType, Object data, Object errorData) {
        Map<String, Object> map = this.requestSerializer.serialize(data);
        return this.send(eventType, map, this.requestSerializer.serialize(errorData));
    }

    @Override
    public MessageId serializeAndSend(EventType eventType, Object data, Object errorData, CorrelationId correlationId) {
        Map<String, Object> payloadMap = this.requestSerializer.serialize(data);
        Map<String, Object> errorPayloadMap = this.requestSerializer.serialize(errorData);
        return this.send(eventType, payloadMap, errorPayloadMap, correlationId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PayloadAndErrorPayload<Map<String, Object>, Map<String, Object>> invokeAndWait(EventType eventType, Map<String, Object> data) throws ExecutionException, InterruptedException {
        ResponseFuture responseFuture = this.messageFunction.request(eventType, data);
        try {
            ProcessingContext<Object> processingContext = responseFuture.getRaw();
            Map<String, Object> payload = this.getPayloadAsMap(processingContext);
            Map<String, Object> errorPayload = this.getErrorPayloadAsMap(processingContext);
            PayloadAndErrorPayload<Map<String, Object>, Map<String, Object>> payloadAndErrorPayload = PayloadAndErrorPayload.payloadAndErrorPayload(payload, errorPayload);
            return payloadAndErrorPayload;
        }
        finally {
            responseFuture.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PayloadAndErrorPayload<Map<String, Object>, Map<String, Object>> invokeAndWait(EventType eventType, Map<String, Object> data, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        ResponseFuture responseFuture = this.messageFunction.request(eventType, data);
        try {
            ProcessingContext<Object> processingContext = responseFuture.getRaw(timeout, unit);
            Map<String, Object> payload = this.getPayloadAsMap(processingContext);
            Map<String, Object> errorPayload = this.getErrorPayloadAsMap(processingContext);
            PayloadAndErrorPayload<Map<String, Object>, Map<String, Object>> payloadAndErrorPayload = PayloadAndErrorPayload.payloadAndErrorPayload(payload, errorPayload);
            return payloadAndErrorPayload;
        }
        finally {
            responseFuture.cancel(true);
        }
    }

    @Override
    public PayloadAndErrorPayload<Map<String, Object>, Map<String, Object>> invokeAndWaitSerializedOnly(EventType eventType, Object data) throws InterruptedException, ExecutionException {
        Map<String, Object> map = this.serializeWithExecutionExceptionWrapper(data);
        return this.invokeAndWait(eventType, map);
    }

    @Override
    public PayloadAndErrorPayload<Map<String, Object>, Map<String, Object>> invokeAndWaitSerializedOnly(EventType eventType, Object data, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Map<String, Object> map = this.serializeWithExecutionExceptionWrapper(data);
        return this.invokeAndWait(eventType, map, timeout, unit);
    }

    @Override
    public <P, E> PayloadAndErrorPayload<P, E> invokeAndWaitDeserialized(EventType eventType, Object data, Class<P> responseClass, Class<E> errorPayloadClass) throws InterruptedException, ExecutionException {
        Map<String, Object> map = this.serializeWithExecutionExceptionWrapper(data);
        PayloadAndErrorPayload<Map<String, Object>, Map<String, Object>> mapPayloadAndErrorPayload = this.invokeAndWait(eventType, map);
        PayloadAndErrorPayload<P, E> payloadAndErrorPayload = this.deserializeWithExecutionExceptionWrapper(responseClass, errorPayloadClass, mapPayloadAndErrorPayload);
        return payloadAndErrorPayload;
    }

    @Override
    public <P, E> PayloadAndErrorPayload<P, E> invokeAndWaitDeserialized(EventType eventType, Object data, Class<P> responseClass, Class<E> errorPayloadClass, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Map<String, Object> map = this.serializeWithExecutionExceptionWrapper(data);
        PayloadAndErrorPayload<Map<String, Object>, Map<String, Object>> mapPayloadAndErrorPayload = this.invokeAndWait(eventType, map, timeout, unit);
        PayloadAndErrorPayload<P, E> payloadAndErrorPayload = this.deserializeWithExecutionExceptionWrapper(responseClass, errorPayloadClass, mapPayloadAndErrorPayload);
        return payloadAndErrorPayload;
    }

    private Map<String, Object> serializeWithExecutionExceptionWrapper(Object data) throws ExecutionException {
        try {
            return this.requestSerializer.serialize(data);
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    private <P, E> PayloadAndErrorPayload<P, E> deserializeWithExecutionExceptionWrapper(Class<P> responseClass, Class<E> errorPayloadClass, PayloadAndErrorPayload<Map<String, Object>, Map<String, Object>> mapPayloadAndErrorPayload) throws ExecutionException {
        try {
            return this.deserialize(mapPayloadAndErrorPayload, responseClass, errorPayloadClass);
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public SubscriptionId subscribe(EventType eventType, Subscriber<PayloadAndErrorPayload<Map<String, Object>, Map<String, Object>>> subscriber) {
        return this.messageBus.subscribeRaw(eventType, new PayloadAndErrorPayloadSubscriberWrapper(subscriber));
    }

    @Override
    public SubscriptionId subscribe(CorrelationId correlationId, Subscriber<PayloadAndErrorPayload<Map<String, Object>, Map<String, Object>>> subscriber) {
        return this.messageBus.subscribe(correlationId, new PayloadAndErrorPayloadSubscriberWrapper(subscriber));
    }

    @Override
    public <P, E> SubscriptionId subscribeDeserialized(EventType eventType, Subscriber<PayloadAndErrorPayload<P, E>> subscriber, Class<P> responseClass, Class<E> errorClass) {
        return this.messageBus.subscribeRaw(eventType, new DeserializingSubscriberWrapper<P, E>(subscriber, responseClass, errorClass));
    }

    @Override
    public <P, E> SubscriptionId subscribeDeserialized(CorrelationId correlationId, Subscriber<PayloadAndErrorPayload<P, E>> subscriber, Class<P> responseClass, Class<E> errorClass) {
        return this.messageBus.subscribe(correlationId, new DeserializingSubscriberWrapper<P, E>(subscriber, responseClass, errorClass));
    }

    @Override
    public SubscriptionId subscribeRaw(EventType eventType, Subscriber<ProcessingContext<Map<String, Object>>> subscriber) {
        Subscriber<ProcessingContext<Object>> castedSubscriber = this.castSubscriber(subscriber);
        return this.messageBus.subscribeRaw(eventType, castedSubscriber);
    }

    private Subscriber<ProcessingContext<Object>> castSubscriber(Subscriber<ProcessingContext<Map<String, Object>>> subscriber) {
        Subscriber<ProcessingContext<Object>> genericErasedSubscriber = subscriber;
        return genericErasedSubscriber;
    }

    private <P, E> PayloadAndErrorPayload<P, E> deserialize(PayloadAndErrorPayload<Map<String, Object>, Map<String, Object>> mapPayloadAndErrorPayload, Class<P> responseClass, Class<E> errorPayloadClass) {
        Map<String, Object> payloadMap = mapPayloadAndErrorPayload.getPayload();
        Map<String, Object> errorPayloadMap = mapPayloadAndErrorPayload.getErrorPayload();
        return this.deserialize(payloadMap, responseClass, errorPayloadMap, errorPayloadClass);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <P, E> PayloadAndErrorPayload<P, E> deserialize(Map<String, Object> payloadMap, Class<P> responseClass, Map<String, Object> errorPayloadMap, Class<E> errorPayloadClass) {
        Object errorPayload;
        Object payload = payloadMap != null ? (Object)this.responseDeserializer.deserialize(responseClass, payloadMap) : null;
        if (errorPayloadMap != null) {
            if (errorPayloadClass == null) throw MissingErrorPayloadClassForDeserialization.missingErrorPayloadClassForDeserialization();
            errorPayload = this.responseDeserializer.deserialize(errorPayloadClass, errorPayloadMap);
            return PayloadAndErrorPayload.payloadAndErrorPayload(payload, errorPayload);
        } else {
            errorPayload = null;
        }
        return PayloadAndErrorPayload.payloadAndErrorPayload(payload, errorPayload);
    }

    @Override
    public void unsubscribe(SubscriptionId subscriptionId) {
        this.messageBus.unsubcribe(subscriptionId);
    }

    private Map<String, Object> getPayloadAsMap(ProcessingContext<Object> processingContext) {
        return (Map)processingContext.getPayload();
    }

    private Map<String, Object> getErrorPayloadAsMap(ProcessingContext<Object> processingContext) {
        return (Map)processingContext.getErrorPayload();
    }

    private final class DeserializingSubscriberWrapper<P, E>
    implements Subscriber<ProcessingContext<Object>> {
        private final SubscriptionId subscriptionId = SubscriptionId.newUniqueId();
        private final Subscriber<PayloadAndErrorPayload<P, E>> subscriber;
        private final Class<P> responseClass;
        private final Class<E> errorClass;

        @Override
        public AcceptingBehavior accept(ProcessingContext<Object> processingContext) {
            Map<String, Object> payloadMap = SerializedMessageBusImpl.this.getPayloadAsMap(processingContext);
            Map<String, Object> errorPayloadMap = SerializedMessageBusImpl.this.getErrorPayloadAsMap(processingContext);
            PayloadAndErrorPayload<P, E> pePayloadAndErrorPayload = SerializedMessageBusImpl.this.deserialize(payloadMap, this.responseClass, errorPayloadMap, this.errorClass);
            return this.subscriber.accept(pePayloadAndErrorPayload);
        }

        @Override
        public SubscriptionId getSubscriptionId() {
            return this.subscriptionId;
        }

        private DeserializingSubscriberWrapper(Subscriber<PayloadAndErrorPayload<P, E>> subscriber, Class<P> responseClass, Class<E> errorClass) {
            this.subscriber = subscriber;
            this.responseClass = responseClass;
            this.errorClass = errorClass;
        }
    }

    private final class PayloadAndErrorPayloadSubscriberWrapper
    implements Subscriber<ProcessingContext<Object>> {
        private final SubscriptionId subscriptionId = SubscriptionId.newUniqueId();
        private final Subscriber<PayloadAndErrorPayload<Map<String, Object>, Map<String, Object>>> subscriber;

        @Override
        public AcceptingBehavior accept(ProcessingContext<Object> processingContext) {
            Map<String, Object> payload = SerializedMessageBusImpl.this.getPayloadAsMap(processingContext);
            Map<String, Object> errorPayload = SerializedMessageBusImpl.this.getErrorPayloadAsMap(processingContext);
            PayloadAndErrorPayload<Map<String, Object>, Map<String, Object>> payloadAndErrorPayload = PayloadAndErrorPayload.payloadAndErrorPayload(payload, errorPayload);
            return this.subscriber.accept(payloadAndErrorPayload);
        }

        @Override
        public SubscriptionId getSubscriptionId() {
            return this.subscriptionId;
        }

        private PayloadAndErrorPayloadSubscriberWrapper(Subscriber<PayloadAndErrorPayload<Map<String, Object>, Map<String, Object>>> subscriber) {
            this.subscriber = subscriber;
        }
    }
}

