/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.mapping;

import de.quantummaid.eventmaid.internal.collections.filtermap.FilterMap;
import de.quantummaid.eventmaid.internal.enforcing.NotNullEnforcer;
import de.quantummaid.eventmaid.mapping.Demapifier;
import java.util.Map;

public final class Deserializer {
    private final FilterMap<Class<?>, Map<String, Object>, Demapifier<?>> demapifierMap;

    public static Deserializer deserializer(FilterMap<Class<?>, Map<String, Object>, Demapifier<?>> requestMappers) {
        NotNullEnforcer.ensureNotNull(requestMappers, "demapifierMap");
        return new Deserializer(requestMappers);
    }

    public <T> T deserialize(Class<T> type, Map<String, Object> map) {
        Demapifier<?> demapifier = this.demapifierMap.get(type, map);
        return (T)demapifier.map(type, map);
    }

    private Deserializer(FilterMap<Class<?>, Map<String, Object>, Demapifier<?>> demapifierMap) {
        this.demapifierMap = demapifierMap;
    }
}

