/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.channel.action;

import de.quantummaid.eventmaid.channel.Channel;
import de.quantummaid.eventmaid.channel.ChannelProcessingFrame;
import de.quantummaid.eventmaid.channel.action.Action;
import de.quantummaid.eventmaid.processingContext.ProcessingContext;

public final class Call<T>
implements Action<T> {
    private final Channel<T> targetChannel;
    private ChannelProcessingFrame<T> returnFrame;
    private ChannelProcessingFrame<T> processingFrameToContinueAfterReturn;

    public static <T> Call<T> callTo(Channel<T> targetChannel, ProcessingContext<T> processingContext) {
        Call<T> call = new Call<T>(targetChannel);
        call.execute(processingContext);
        return call;
    }

    public static <T> Call<T> prepareACall(Channel<T> targetChannel) {
        return new Call<T>(targetChannel);
    }

    public void execute(ProcessingContext<T> processingContext) {
        ChannelProcessingFrame<T> currentProcessingFrame = processingContext.getCurrentProcessingFrame();
        this.processingFrameToContinueAfterReturn = currentProcessingFrame.copy();
        currentProcessingFrame.setAction(this);
        this.targetChannel.send(processingContext);
    }

    private Call(Channel<T> targetChannel) {
        this.targetChannel = targetChannel;
    }

    public Channel<T> getTargetChannel() {
        return this.targetChannel;
    }

    public ChannelProcessingFrame<T> getReturnFrame() {
        return this.returnFrame;
    }

    public void setReturnFrame(ChannelProcessingFrame<T> returnFrame) {
        this.returnFrame = returnFrame;
    }

    public ChannelProcessingFrame<T> getProcessingFrameToContinueAfterReturn() {
        return this.processingFrameToContinueAfterReturn;
    }
}

