/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.preparing.tableOfContents;

import de.quantummaid.documaid.collecting.structure.Directory;
import de.quantummaid.documaid.collecting.structure.Project;
import de.quantummaid.documaid.collecting.structure.ProjectFile;
import de.quantummaid.documaid.domain.markdown.MarkdownFile;
import de.quantummaid.documaid.domain.markdown.tagBased.RawMarkdownDirective;
import de.quantummaid.documaid.domain.markdown.tagBased.tableOfContents.GithubTableOfContentsMarkdownTagHandler;
import de.quantummaid.documaid.domain.markdown.tagBased.tableOfContents.TableOfContentsDirective;
import de.quantummaid.documaid.domain.tableOfContents.TableOfContents;
import de.quantummaid.documaid.domain.tableOfContents.TableOfContentsCreator;
import de.quantummaid.documaid.domain.tableOfContents.TocTraversalDecision;
import de.quantummaid.documaid.errors.VerificationError;
import de.quantummaid.documaid.preparing.PreparingVisitor;
import de.quantummaid.documaid.preparing.tableOfContents.TableOfContentsLookupData;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0005\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\f\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J&\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lde/quantummaid/documaid/preparing/tableOfContents/TableOfContentsPreparer;", "Lde/quantummaid/documaid/preparing/PreparingVisitor;", "()V", "tableOfContentsLookupData", "Lde/quantummaid/documaid/preparing/tableOfContents/TableOfContentsLookupData;", "generateToc", "Lkotlin/Pair;", "Lde/quantummaid/documaid/domain/tableOfContents/TableOfContents;", "", "Lde/quantummaid/documaid/errors/VerificationError;", "directive", "Lde/quantummaid/documaid/domain/markdown/tagBased/RawMarkdownDirective;", "file", "Lde/quantummaid/documaid/domain/markdown/MarkdownFile;", "project", "Lde/quantummaid/documaid/collecting/structure/Project;", "prepareFile", "Lde/quantummaid/documaid/collecting/structure/ProjectFile;", "prepareToc", "startPreparation", "", "documaid"})
public final class TableOfContentsPreparer
implements PreparingVisitor {
    private final TableOfContentsLookupData tableOfContentsLookupData = new TableOfContentsLookupData();

    @Override
    public void startPreparation(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        project.setInformation(TableOfContentsLookupData.Companion.getTOC_LOOKUP_KEY(), this.tableOfContentsLookupData);
    }

    @Override
    @NotNull
    public List<VerificationError> prepareFile(@NotNull ProjectFile file, @NotNull Project project) {
        List list;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (file instanceof MarkdownFile) {
            List<RawMarkdownDirective> tocDirectives = ((MarkdownFile)file).markdownDirectivesWithIdentifier(TableOfContentsDirective.Companion.getTOC_TAG());
            if (tocDirectives.isEmpty()) {
                list = CollectionsKt.emptyList();
            } else if (tocDirectives.size() == 1) {
                list = this.prepareToc(tocDirectives.get(0), (MarkdownFile)file, project);
            } else {
                String message2 = "" + '[' + TableOfContentsDirective.Companion.getTOC_TAG() + "] Found multiple Table of contents in a single file " + file.absolutePath();
                list = CollectionsKt.listOf((Object)VerificationError.Companion.create(message2, file));
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<VerificationError> prepareToc(RawMarkdownDirective directive, MarkdownFile file, Project project) {
        void tableOfContents;
        if (this.tableOfContentsLookupData.tableOfContentsAvailable()) {
            String message2 = "" + '[' + TableOfContentsDirective.Companion.getTOC_TAG() + "] cannot generate Table of Contents for file '" + file.absolutePath() + ", " + "because one has already been created";
            VerificationError verificationError = VerificationError.Companion.create(message2, file);
            return CollectionsKt.listOf((Object)verificationError);
        }
        Object object = this.generateToc(directive, file, project);
        TableOfContents message2 = (TableOfContents)object.component1();
        List errors = (List)object.component2();
        object = errors;
        boolean bl = false;
        if (!object.isEmpty() || tableOfContents == null) {
            return errors;
        }
        this.tableOfContentsLookupData.registerTableOfContents((TableOfContents)tableOfContents);
        return CollectionsKt.emptyList();
    }

    private final Pair<TableOfContents, List<VerificationError>> generateToc(RawMarkdownDirective directive, MarkdownFile file, Project project) {
        try {
            TableOfContentsDirective tableOfContentsDirective = TableOfContentsDirective.Companion.create(directive, file, project);
            TocTraversalDecision traversalDecision2 = new TocTraversalDecision(){

                public boolean directoryShouldBeTraversed(@NotNull Directory directory) {
                    Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
                    String fileName = ((Object)directory.absolutePath().getFileName()).toString();
                    return GithubTableOfContentsMarkdownTagHandler.Companion.getINDEX_MARKDOWN_FILE_NAME_PATTERN().matches((CharSequence)fileName);
                }
            };
            TableOfContentsCreator tableOfContentsCollector = new TableOfContentsCreator(traversalDecision2);
            return tableOfContentsCollector.createFrom(tableOfContentsDirective, file);
        }
        catch (Exception e) {
            return new Pair(null, (Object)CollectionsKt.listOf((Object)VerificationError.Companion.createFromException(e, file)));
        }
    }

    @Override
    @NotNull
    public List<VerificationError> beforeDirectoryPreparing(@NotNull Directory directory, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return PreparingVisitor.DefaultImpls.beforeDirectoryPreparing(this, directory, project);
    }

    @Override
    @NotNull
    public List<VerificationError> afterDirectoryPreparing(@NotNull Directory directory, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return PreparingVisitor.DefaultImpls.afterDirectoryPreparing(this, directory, project);
    }

    @Override
    @NotNull
    public List<VerificationError> finishPreparation(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return PreparingVisitor.DefaultImpls.finishPreparation(this, project);
    }
}

