/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.domain.markdown.tagBased.navigation;

import de.quantummaid.documaid.collecting.structure.Project;
import de.quantummaid.documaid.domain.markdown.MarkdownFile;
import de.quantummaid.documaid.domain.markdown.tagBased.DirectiveTag;
import de.quantummaid.documaid.domain.markdown.tagBased.RawMarkdownDirective;
import de.quantummaid.documaid.domain.markdown.tagBased.navigation.GithubNavigationMarkdown;
import de.quantummaid.documaid.domain.tableOfContents.TableOfContents;
import de.quantummaid.documaid.preparing.tableOfContents.TableOfContentsLookupData;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB3\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lde/quantummaid/documaid/domain/markdown/tagBased/navigation/NavigationDirective;", "", "directive", "Lde/quantummaid/documaid/domain/markdown/tagBased/RawMarkdownDirective;", "file", "Lde/quantummaid/documaid/domain/markdown/MarkdownFile;", "previousFile", "overviewFile", "nextFile", "(Lde/quantummaid/documaid/domain/markdown/tagBased/RawMarkdownDirective;Lde/quantummaid/documaid/domain/markdown/MarkdownFile;Lde/quantummaid/documaid/domain/markdown/MarkdownFile;Lde/quantummaid/documaid/domain/markdown/MarkdownFile;Lde/quantummaid/documaid/domain/markdown/MarkdownFile;)V", "getDirective", "()Lde/quantummaid/documaid/domain/markdown/tagBased/RawMarkdownDirective;", "generateMarkdown", "Lde/quantummaid/documaid/domain/markdown/tagBased/navigation/GithubNavigationMarkdown;", "Companion", "documaid"})
public final class NavigationDirective {
    @NotNull
    private final RawMarkdownDirective directive;
    private final MarkdownFile file;
    private final MarkdownFile previousFile;
    private final MarkdownFile overviewFile;
    private final MarkdownFile nextFile;
    @NotNull
    private static final DirectiveTag NAV_TAG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final GithubNavigationMarkdown generateMarkdown() {
        return GithubNavigationMarkdown.Companion.create(this.file, this.previousFile, this.overviewFile, this.nextFile);
    }

    @NotNull
    public final RawMarkdownDirective getDirective() {
        return this.directive;
    }

    private NavigationDirective(RawMarkdownDirective directive, MarkdownFile file, MarkdownFile previousFile, MarkdownFile overviewFile, MarkdownFile nextFile) {
        this.directive = directive;
        this.file = file;
        this.previousFile = previousFile;
        this.overviewFile = overviewFile;
        this.nextFile = nextFile;
    }

    static {
        Companion = new Companion(null);
        NAV_TAG = new DirectiveTag("Nav");
    }

    public /* synthetic */ NavigationDirective(RawMarkdownDirective directive, MarkdownFile file, MarkdownFile previousFile, MarkdownFile overviewFile, MarkdownFile nextFile, DefaultConstructorMarker $constructor_marker) {
        this(directive, file, previousFile, overviewFile, nextFile);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lde/quantummaid/documaid/domain/markdown/tagBased/navigation/NavigationDirective$Companion;", "", "()V", "NAV_TAG", "Lde/quantummaid/documaid/domain/markdown/tagBased/DirectiveTag;", "getNAV_TAG", "()Lde/quantummaid/documaid/domain/markdown/tagBased/DirectiveTag;", "create", "Lde/quantummaid/documaid/domain/markdown/tagBased/navigation/NavigationDirective;", "rawMarkdownDirective", "Lde/quantummaid/documaid/domain/markdown/tagBased/RawMarkdownDirective;", "file", "Lde/quantummaid/documaid/domain/markdown/MarkdownFile;", "project", "Lde/quantummaid/documaid/collecting/structure/Project;", "documaid"})
    public static final class Companion {
        @NotNull
        public final DirectiveTag getNAV_TAG() {
            return NAV_TAG;
        }

        @NotNull
        public final NavigationDirective create(@NotNull RawMarkdownDirective rawMarkdownDirective, @NotNull MarkdownFile file, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)rawMarkdownDirective, (String)"rawMarkdownDirective");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            TableOfContentsLookupData tableOfContentsLookupData = project.getInformation(TableOfContentsLookupData.Companion.getTOC_LOOKUP_KEY());
            TableOfContents tableOfContents = tableOfContentsLookupData.getTableOfContents();
            MarkdownFile overviewFile = tableOfContents.getFileWithToc();
            MarkdownFile previousFile = tableOfContents.getFilePredecessor(file);
            MarkdownFile nextFile = tableOfContents.getFileSuccessor(file);
            return new NavigationDirective(rawMarkdownDirective, file, previousFile, overviewFile, nextFile, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

