/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.domain.markdown.tagBased.archetype;

import de.quantummaid.documaid.collecting.structure.Project;
import de.quantummaid.documaid.domain.markdown.MarkdownFile;
import de.quantummaid.documaid.domain.markdown.RemainingMarkupFileContent;
import de.quantummaid.documaid.domain.markdown.tagBased.MarkdownReplacement;
import de.quantummaid.documaid.domain.markdown.tagBased.MarkdownTagHandler;
import de.quantummaid.documaid.domain.markdown.tagBased.RawMarkdownDirective;
import de.quantummaid.documaid.domain.markdown.tagBased.archetype.ArchetypeDirective;
import de.quantummaid.documaid.domain.markdown.tagBased.archetype.ArchetypeMarkdown;
import de.quantummaid.documaid.domain.markdown.tagBased.matching.TrailingMarkdownMatchResult;
import de.quantummaid.documaid.errors.VerificationError;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00110\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J&\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0013"}, d2={"Lde/quantummaid/documaid/domain/markdown/tagBased/archetype/ArchetypeMarkdownHandler;", "Lde/quantummaid/documaid/domain/markdown/tagBased/MarkdownTagHandler;", "()V", "generate", "Lkotlin/Pair;", "Lde/quantummaid/documaid/domain/markdown/tagBased/MarkdownReplacement;", "", "Lde/quantummaid/documaid/errors/VerificationError;", "directive", "Lde/quantummaid/documaid/domain/markdown/tagBased/RawMarkdownDirective;", "file", "Lde/quantummaid/documaid/domain/markdown/MarkdownFile;", "project", "Lde/quantummaid/documaid/collecting/structure/Project;", "tag", "", "textToBeReplaced", "Lde/quantummaid/documaid/domain/markdown/tagBased/matching/TrailingMarkdownMatchResult;", "validate", "documaid"})
public final class ArchetypeMarkdownHandler
implements MarkdownTagHandler {
    @Override
    @NotNull
    public String tag() {
        return ArchetypeDirective.Companion.getARCHETYPE_TAG().getValue();
    }

    @Override
    @NotNull
    public Pair<MarkdownReplacement, List<VerificationError>> generate(@NotNull RawMarkdownDirective directive, @NotNull MarkdownFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ArchetypeDirective archetypeDirective = ArchetypeDirective.Companion.create(directive, file, project);
        String textToReplace = archetypeDirective.generateCompleteMarkdown();
        Pair<String, TrailingMarkdownMatchResult> pair = this.textToBeReplaced(directive);
        String textToBeReplaced = (String)pair.component1();
        int rangeStart = directive.getRange().getFirst();
        int rangeEnd = rangeStart + Math.max(textToBeReplaced.length(), textToReplace.length());
        return new Pair((Object)new MarkdownReplacement(new IntRange(rangeStart, rangeEnd), textToBeReplaced, textToReplace), (Object)CollectionsKt.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<VerificationError> validate(@NotNull RawMarkdownDirective directive, @NotNull MarkdownFile file, @NotNull Project project) {
        List list;
        void textToBeReplaced;
        Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ArchetypeDirective archetypeDirective = ArchetypeDirective.Companion.create(directive, file, project);
        String textToReplace = archetypeDirective.generateCompleteMarkdown();
        Pair<String, TrailingMarkdownMatchResult> pair = this.textToBeReplaced(directive);
        String string = (String)pair.component1();
        TrailingMarkdownMatchResult trailingMarkdownMatchResult = (TrailingMarkdownMatchResult)pair.component2();
        if (Intrinsics.areEqual((Object)textToBeReplaced, (Object)textToReplace) ^ true) {
            boolean trailingCodeFound = trailingMarkdownMatchResult.getMatches();
            if (trailingCodeFound) {
                String message2 = "Found [" + this.tag() + "] tag with incorrect archetype code for '" + directive.getCompleteString() + '\'';
                list = CollectionsKt.listOf((Object)VerificationError.Companion.create(message2, file));
            } else {
                String message3 = "Found [" + this.tag() + "] tag with missing archetype code for '" + directive.getCompleteString() + '\'';
                list = CollectionsKt.listOf((Object)VerificationError.Companion.create(message3, file));
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final Pair<String, TrailingMarkdownMatchResult> textToBeReplaced(RawMarkdownDirective directive) {
        RemainingMarkupFileContent remainingContent = directive.getRemainingMarkupFileContent();
        TrailingMarkdownMatchResult trailingMarkdownMatchResult = ArchetypeMarkdown.Companion.startsWithArchetypeMarkdown(remainingContent);
        String text = trailingMarkdownMatchResult.getMatches() ? directive.getCompleteString() + trailingMarkdownMatchResult.getContent() : directive.getCompleteString();
        return new Pair((Object)text, (Object)trailingMarkdownMatchResult);
    }
}

