/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.domain.markdown.syntaxBased.hugo.heading;

import de.quantummaid.documaid.domain.hugo.documentation.HugoDocumentationGenerationInformation;
import de.quantummaid.documaid.domain.hugo.documentationWeights.HugoWeight;
import de.quantummaid.documaid.domain.markdown.MarkdownFile;
import de.quantummaid.documaid.domain.paths.IndexedPath;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\u0003J\u0006\u0010\b\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lde/quantummaid/documaid/domain/markdown/syntaxBased/hugo/heading/HugoHeadingMarkdown;", "", "title", "", "weight", "Lde/quantummaid/documaid/domain/hugo/documentationWeights/HugoWeight;", "(Ljava/lang/String;Lde/quantummaid/documaid/domain/hugo/documentationWeights/HugoWeight;)V", "generateMarkdown", "generateMarkdownWithSkipParam", "Companion", "documaid"})
public final class HugoHeadingMarkdown {
    private final String title;
    private final HugoWeight weight;
    private static final Regex RAW_HEADING_PATTERN;
    public static final Companion Companion;

    @NotNull
    public final String generateMarkdown() {
        return StringsKt.trimIndent((String)("\n            ---\n            title: \"" + this.title + "\"\n            weight: " + this.weight.getValue() + "\n            ---\n        ")) + "\n";
    }

    @NotNull
    public final String generateMarkdownWithSkipParam() {
        return StringsKt.trimIndent((String)("\n            ---\n            title: \"" + this.title + "\"\n            weight: " + this.weight.getValue() + "\n            skip: \"true\"\n            ---\n        ")) + "\n";
    }

    private HugoHeadingMarkdown(String title, HugoWeight weight) {
        this.title = title;
        this.weight = weight;
    }

    static {
        Companion = new Companion(null);
        RAW_HEADING_PATTERN = new Regex("# ?(?<title>[^\n]+)\n");
    }

    public /* synthetic */ HugoHeadingMarkdown(String title, HugoWeight weight, DefaultConstructorMarker $constructor_marker) {
        this(title, weight);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lde/quantummaid/documaid/domain/markdown/syntaxBased/hugo/heading/HugoHeadingMarkdown$Companion;", "", "()V", "RAW_HEADING_PATTERN", "Lkotlin/text/Regex;", "create", "Lde/quantummaid/documaid/domain/markdown/syntaxBased/hugo/heading/HugoHeadingMarkdown;", "title", "", "weight", "Lde/quantummaid/documaid/domain/hugo/documentationWeights/HugoWeight;", "rawHeadingString", "file", "Lde/quantummaid/documaid/domain/markdown/MarkdownFile;", "createWeight", "documaid"})
    public static final class Companion {
        @NotNull
        public final HugoHeadingMarkdown create(@NotNull String rawHeadingString, @NotNull MarkdownFile file) {
            Intrinsics.checkNotNullParameter((Object)rawHeadingString, (String)"rawHeadingString");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            MatchResult matchEntire = RAW_HEADING_PATTERN.matchEntire((CharSequence)rawHeadingString);
            String errorMessage = "Could not parse title of heading: '" + rawHeadingString + '\'';
            if (matchEntire == null) {
                throw (Throwable)new IllegalArgumentException(errorMessage);
            }
            Object object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchEntire.getGroups(), (String)"title");
            if (object == null || (object = object.getValue()) == null) {
                throw (Throwable)new IllegalArgumentException(errorMessage);
            }
            Object title = object;
            HugoWeight hugoWeight = this.createWeight(file);
            return new HugoHeadingMarkdown((String)title, hugoWeight, null);
        }

        /*
         * WARNING - void declaration
         */
        private final HugoWeight createWeight(MarkdownFile file) {
            HugoWeight hugoWeight;
            if (file.hasDataFor(HugoDocumentationGenerationInformation.Companion.getDOCUMENTATION_GEN_INFO_KEY())) {
                void var3_4;
                HugoDocumentationGenerationInformation generationInformation = file.getData(HugoDocumentationGenerationInformation.Companion.getDOCUMENTATION_GEN_INFO_KEY());
                String string = generationInformation.getWeight();
                Intrinsics.checkNotNull((Object)string);
                HugoWeight hugoWeight2 = HugoWeight.Companion.createForMultiLevelWeight(string);
                hugoWeight = var3_4;
            } else if (IndexedPath.Companion.isIndexedPath(file)) {
                IndexedPath indexedPath = IndexedPath.Companion.anIndexedPath(file);
                hugoWeight = HugoWeight.Companion.createForIndividualWeight(String.valueOf(indexedPath.getIndex()));
            } else {
                hugoWeight = HugoWeight.Companion.createForIndividualWeight("0");
            }
            return hugoWeight;
        }

        @NotNull
        public final HugoHeadingMarkdown create(@NotNull String title, @NotNull HugoWeight weight) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)weight, (String)"weight");
            return new HugoHeadingMarkdown(title, weight, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

