/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.domain.hugo.documentation;

import de.quantummaid.documaid.collecting.structure.CollectedInformationKey;
import de.quantummaid.documaid.collecting.structure.Directory;
import de.quantummaid.documaid.collecting.structure.FileObject;
import de.quantummaid.documaid.collecting.structure.FileObjectVisitorAdapter;
import de.quantummaid.documaid.collecting.structure.Project;
import de.quantummaid.documaid.collecting.structure.ProjectFile;
import de.quantummaid.documaid.config.DocuMaidConfiguration;
import de.quantummaid.documaid.domain.hugo.documentation.DocumentationUtilsKt;
import de.quantummaid.documaid.domain.hugo.documentation.HugoDocumentationGenerationInformation;
import de.quantummaid.documaid.domain.markdown.MarkdownFile;
import de.quantummaid.documaid.domain.paths.IndexedPath;
import de.quantummaid.documaid.domain.paths.PathUtilsKt;
import java.nio.file.Path;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lde/quantummaid/documaid/domain/hugo/documentation/HugoDocumentationCollector;", "Lde/quantummaid/documaid/collecting/structure/FileObjectVisitorAdapter;", "docuMaidConfiguration", "Lde/quantummaid/documaid/config/DocuMaidConfiguration;", "(Lde/quantummaid/documaid/config/DocuMaidConfiguration;)V", "maxLevelOfIndexedDocumentationSubDirectories", "", "calculateLevelWithinDocumentation", "absolutePath", "Ljava/nio/file/Path;", "directoryVisited", "", "directory", "Lde/quantummaid/documaid/collecting/structure/Directory;", "fileVisited", "file", "Lde/quantummaid/documaid/collecting/structure/ProjectFile;", "finishTreeWalk", "project", "Lde/quantummaid/documaid/collecting/structure/Project;", "isDocumentationFileOfInterest", "", "isWithinDocuDirAndOfInterest", "Companion", "documaid"})
public final class HugoDocumentationCollector
extends FileObjectVisitorAdapter {
    private int maxLevelOfIndexedDocumentationSubDirectories;
    private final DocuMaidConfiguration docuMaidConfiguration;
    @NotNull
    private static final CollectedInformationKey<Directory> DOCUMENTATION_ROOT_DIRECTORY;
    public static final Companion Companion;

    @Override
    public void fileVisited(@NotNull ProjectFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Path absolutePath = file.absolutePath();
        if (this.isDocumentationFileOfInterest(file, absolutePath)) {
            file.setData(HugoDocumentationGenerationInformation.Companion.getDOCUMENTATION_GEN_INFO_KEY(), HugoDocumentationGenerationInformation.Companion.hugoGenerationInformationForFile((MarkdownFile)file));
        }
    }

    private final boolean isDocumentationFileOfInterest(ProjectFile file, Path absolutePath) {
        return file instanceof MarkdownFile ? (DocumentationUtilsKt.isWithinDocumentationDirectory(absolutePath, this.docuMaidConfiguration) ? (PathUtilsKt.pathMatchesFileNameExactly(absolutePath, "_index.md") ? true : !DocumentationUtilsKt.isWithinLegacyDirectory(absolutePath, this.docuMaidConfiguration) && IndexedPath.Companion.isIndexedPath(absolutePath)) : false) : false;
    }

    @Override
    public void directoryVisited(@NotNull Directory directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Path absolutePath = directory.absolutePath();
        if (this.isWithinDocuDirAndOfInterest(absolutePath)) {
            int levelWithinDocu = this.calculateLevelWithinDocumentation(absolutePath);
            HugoDocumentationGenerationInformation generationInformation = HugoDocumentationGenerationInformation.Companion.hugoGenerationInformationForDirectory(directory, levelWithinDocu);
            directory.setData(HugoDocumentationGenerationInformation.Companion.getDOCUMENTATION_GEN_INFO_KEY(), generationInformation);
            this.maxLevelOfIndexedDocumentationSubDirectories = Math.max(levelWithinDocu, this.maxLevelOfIndexedDocumentationSubDirectories);
        }
    }

    private final boolean isWithinDocuDirAndOfInterest(Path absolutePath) {
        boolean bl;
        if (DocumentationUtilsKt.isWithinDocumentationDirectory(absolutePath, this.docuMaidConfiguration)) {
            if (DocumentationUtilsKt.isDocumentationDirectory(absolutePath, this.docuMaidConfiguration)) {
                return true;
            }
            bl = !DocumentationUtilsKt.isWithinLegacyDirectory(absolutePath, this.docuMaidConfiguration) && IndexedPath.Companion.isIndexedPath(absolutePath);
        } else {
            bl = false;
        }
        return bl;
    }

    private final int calculateLevelWithinDocumentation(Path absolutePath) {
        Path rootRelativePath = PathUtilsKt.makeRelativeTo(absolutePath, this.docuMaidConfiguration.getBasePath());
        int level = 0;
        Iterator<Path> iterator = rootRelativePath.iterator();
        while (iterator.hasNext()) {
            Path path;
            Path path2 = path = iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
            if (!IndexedPath.Companion.isIndexedPath(path2)) continue;
            ++level;
        }
        if (IndexedPath.Companion.isIndexedPath(this.docuMaidConfiguration.getHugoOutputPath())) {
            ++level;
        }
        return level;
    }

    @Override
    public void finishTreeWalk(@NotNull Project project) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Iterable $this$firstOrNull$iv = project.getRootDirectory().children();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FileObject it = (FileObject)element$iv;
                boolean bl = false;
                if (!PathUtilsKt.pathMatchesFileNameExactly(it.absolutePath(), "documentation")) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        FileObject documentationDirectory = v0;
        if (documentationDirectory != null) {
            project.setInformation(DOCUMENTATION_ROOT_DIRECTORY, documentationDirectory);
            HugoDocumentationGenerationInformation generationInformation = documentationDirectory.getData(HugoDocumentationGenerationInformation.Companion.getDOCUMENTATION_GEN_INFO_KEY());
            generationInformation.setTargetPath(this.docuMaidConfiguration.absoluteHugoOutputPath());
            project.setInformation(HugoDocumentationGenerationInformation.Companion.getDOCUMENTATION_MAX_LEVEL(), this.maxLevelOfIndexedDocumentationSubDirectories);
        }
    }

    public HugoDocumentationCollector(@NotNull DocuMaidConfiguration docuMaidConfiguration) {
        Intrinsics.checkNotNullParameter((Object)docuMaidConfiguration, (String)"docuMaidConfiguration");
        this.docuMaidConfiguration = docuMaidConfiguration;
        this.maxLevelOfIndexedDocumentationSubDirectories = this.docuMaidConfiguration.getDocumentationDepth();
    }

    static {
        Companion = new Companion(null);
        DOCUMENTATION_ROOT_DIRECTORY = new CollectedInformationKey("DOCUMENTATION_ROOT_DIRECTORY");
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lde/quantummaid/documaid/domain/hugo/documentation/HugoDocumentationCollector$Companion;", "", "()V", "DOCUMENTATION_ROOT_DIRECTORY", "Lde/quantummaid/documaid/collecting/structure/CollectedInformationKey;", "Lde/quantummaid/documaid/collecting/structure/Directory;", "getDOCUMENTATION_ROOT_DIRECTORY", "()Lde/quantummaid/documaid/collecting/structure/CollectedInformationKey;", "documaid"})
    public static final class Companion {
        @NotNull
        public final CollectedInformationKey<Directory> getDOCUMENTATION_ROOT_DIRECTORY() {
            return DOCUMENTATION_ROOT_DIRECTORY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

