/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.config;

import de.quantummaid.documaid.config.DocuMaidConfiguration;
import de.quantummaid.documaid.config.GithubRepository;
import de.quantummaid.documaid.config.Goal;
import de.quantummaid.documaid.config.MavenConfiguration;
import de.quantummaid.documaid.config.Platform;
import de.quantummaid.documaid.config.Repository;
import de.quantummaid.documaid.logging.Logger;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 #2\u00020\u0001:\u0001#B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0006J\u0010\u0010\u001a\u001a\u00020\u00002\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0006J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u001e\u001a\u00020\u00002\b\u0010\u001f\u001a\u0004\u0018\u00010\u0006J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0006J\u0014\u0010\"\u001a\u00020\u00002\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0014R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lde/quantummaid/documaid/config/DocuMaidConfigurationBuilder;", "", "()V", "basePath", "Ljava/nio/file/Path;", "generationFlavorType", "", "goal", "Lde/quantummaid/documaid/config/Goal;", "hugoOutputPath", "logger", "Lde/quantummaid/documaid/logging/Logger;", "mavenConfiguration", "Lde/quantummaid/documaid/config/MavenConfiguration;", "overriddenDocumentationDepth", "platform", "Lde/quantummaid/documaid/config/Platform;", "repository", "Lde/quantummaid/documaid/config/Repository;", "skippedPaths", "", "build", "Lde/quantummaid/documaid/config/DocuMaidConfiguration;", "forGoal", "forPlatform", "withBasePath", "withGenerationFlavorType", "withHugoOutputPath", "withLogger", "withMavenConfiguration", "withOverriddenDocumentationDepth", "overridenDocumentationDepth", "withRepositoryUrl", "repositoryBaseUrl", "withSkippedPaths", "Companion", "documaid"})
public final class DocuMaidConfigurationBuilder {
    private Path basePath;
    private Goal goal;
    private Logger logger;
    private MavenConfiguration mavenConfiguration = new MavenConfiguration(null, null, null);
    private List<? extends Path> skippedPaths = CollectionsKt.emptyList();
    private Platform platform = Platform.GITHUB;
    private String hugoOutputPath = "hugo";
    private Repository repository;
    private String generationFlavorType;
    private String overriddenDocumentationDepth;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final DocuMaidConfigurationBuilder withBasePath(@NotNull String basePath) {
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        this.basePath = Paths.get(basePath, new String[0]);
        return this;
    }

    @NotNull
    public final DocuMaidConfigurationBuilder withBasePath(@NotNull Path basePath) {
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        this.basePath = basePath;
        return this;
    }

    @NotNull
    public final DocuMaidConfigurationBuilder forGoal(@NotNull Goal goal) {
        Intrinsics.checkNotNullParameter((Object)((Object)goal), (String)"goal");
        this.goal = goal;
        return this;
    }

    @NotNull
    public final DocuMaidConfigurationBuilder withLogger(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        return this;
    }

    @NotNull
    public final DocuMaidConfigurationBuilder withMavenConfiguration(@NotNull MavenConfiguration mavenConfiguration) {
        Intrinsics.checkNotNullParameter((Object)mavenConfiguration, (String)"mavenConfiguration");
        this.mavenConfiguration = mavenConfiguration;
        return this;
    }

    @NotNull
    public final DocuMaidConfigurationBuilder withSkippedPaths(@NotNull List<? extends Path> skippedPaths) {
        Intrinsics.checkNotNullParameter(skippedPaths, (String)"skippedPaths");
        this.skippedPaths = skippedPaths;
        return this;
    }

    @NotNull
    public final DocuMaidConfigurationBuilder forPlatform(@NotNull Platform platform) {
        Intrinsics.checkNotNullParameter((Object)((Object)platform), (String)"platform");
        this.platform = platform;
        return this;
    }

    @NotNull
    public final DocuMaidConfigurationBuilder withHugoOutputPath(@NotNull String hugoOutputPath) {
        Intrinsics.checkNotNullParameter((Object)hugoOutputPath, (String)"hugoOutputPath");
        this.hugoOutputPath = hugoOutputPath;
        return this;
    }

    @NotNull
    public final DocuMaidConfigurationBuilder withRepositoryUrl(@NotNull String repositoryBaseUrl) {
        Intrinsics.checkNotNullParameter((Object)repositoryBaseUrl, (String)"repositoryBaseUrl");
        this.repository = GithubRepository.Companion.create(repositoryBaseUrl);
        return this;
    }

    @NotNull
    public final DocuMaidConfigurationBuilder withGenerationFlavorType(@Nullable String generationFlavorType) {
        this.generationFlavorType = generationFlavorType;
        return this;
    }

    @NotNull
    public final DocuMaidConfigurationBuilder withOverriddenDocumentationDepth(@Nullable String overridenDocumentationDepth) {
        this.overriddenDocumentationDepth = overridenDocumentationDepth;
        return this;
    }

    @NotNull
    public final DocuMaidConfiguration build() {
        Path path = this.basePath;
        Intrinsics.checkNotNull((Object)path);
        Path absolutePath = path.toAbsolutePath();
        int documentationDepth = this.overriddenDocumentationDepth != null ? Integer.parseInt(this.overriddenDocumentationDepth) : 0;
        Path path2 = absolutePath;
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"absolutePath");
        Goal goal = this.goal;
        Intrinsics.checkNotNull((Object)((Object)goal));
        Logger logger = this.logger;
        Intrinsics.checkNotNull((Object)logger);
        return new DocuMaidConfiguration(path2, goal, logger, this.mavenConfiguration, this.skippedPaths, this.platform, this.hugoOutputPath, this.repository, this.generationFlavorType, documentationDepth);
    }

    private DocuMaidConfigurationBuilder() {
    }

    public /* synthetic */ DocuMaidConfigurationBuilder(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lde/quantummaid/documaid/config/DocuMaidConfigurationBuilder$Companion;", "", "()V", "builder", "Lde/quantummaid/documaid/config/DocuMaidConfigurationBuilder;", "documaid"})
    public static final class Companion {
        @NotNull
        public final DocuMaidConfigurationBuilder builder() {
            return new DocuMaidConfigurationBuilder(null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

