/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.collecting.snippets;

import de.quantummaid.documaid.collecting.structure.CollectedInformationKey;
import de.quantummaid.documaid.domain.snippet.SnippetId;
import de.quantummaid.documaid.errors.DocuMaidException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0005R6\u0010\u0003\u001a*\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004j\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/quantummaid/documaid/collecting/snippets/CodeSnippetsLookupTable;", "", "()V", "map", "Ljava/util/HashMap;", "Lde/quantummaid/documaid/domain/snippet/SnippetId;", "", "Ljava/nio/file/Path;", "Lkotlin/collections/HashMap;", "getUniqueSnippet", "snippetId", "registerSnippet", "", "path", "uniqueSnippetExists", "", "Companion", "documaid"})
public final class CodeSnippetsLookupTable {
    private final HashMap<SnippetId, List<Path>> map = new HashMap();
    private static final String keyName;
    @NotNull
    private static final CollectedInformationKey<CodeSnippetsLookupTable> SNIPPETS_LOOKUP_TABLE_KEY;
    public static final Companion Companion;

    public final void registerSnippet(@NotNull SnippetId snippetId, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)snippetId, (String)"snippetId");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (this.map.containsKey(snippetId)) {
            List<Path> list = this.map.get(snippetId);
            if (list != null) {
                list.add(path);
            }
        } else {
            ((Map)this.map).put(snippetId, CollectionsKt.mutableListOf((Object[])new Path[]{path}));
        }
    }

    public final boolean uniqueSnippetExists(@NotNull SnippetId snippetId) {
        List<Path> list;
        Intrinsics.checkNotNullParameter((Object)snippetId, (String)"snippetId");
        List<Path> list2 = list = this.map.get(snippetId);
        return list2 != null && list2.size() == 1;
    }

    @NotNull
    public final Path getUniqueSnippet(@NotNull SnippetId snippetId) {
        List<Path> list;
        Intrinsics.checkNotNullParameter((Object)snippetId, (String)"snippetId");
        List<Path> list2 = list = this.map.get(snippetId);
        Intrinsics.checkNotNull(list2);
        if (list2.size() == 1) {
            return list.get(0);
        }
        throw (Throwable)DocuMaidException.Companion.createWithoutFileOrigin("Snippet " + snippetId + " was not unique");
    }

    static {
        Companion = new Companion(null);
        keyName = "SNIPPETS_LOOKUP_TABLE_KEY";
        SNIPPETS_LOOKUP_TABLE_KEY = new CollectedInformationKey(keyName);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lde/quantummaid/documaid/collecting/snippets/CodeSnippetsLookupTable$Companion;", "", "()V", "SNIPPETS_LOOKUP_TABLE_KEY", "Lde/quantummaid/documaid/collecting/structure/CollectedInformationKey;", "Lde/quantummaid/documaid/collecting/snippets/CodeSnippetsLookupTable;", "getSNIPPETS_LOOKUP_TABLE_KEY", "()Lde/quantummaid/documaid/collecting/structure/CollectedInformationKey;", "keyName", "", "documaid"})
    public static final class Companion {
        @NotNull
        public final CollectedInformationKey<CodeSnippetsLookupTable> getSNIPPETS_LOOKUP_TABLE_KEY() {
            return SNIPPETS_LOOKUP_TABLE_KEY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

