/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.domain.markdown.tagBased.tableOfContents;

import de.quantummaid.documaid.collecting.structure.Project;
import de.quantummaid.documaid.domain.markdown.MarkdownFile;
import de.quantummaid.documaid.domain.markdown.tagBased.MarkdownReplacement;
import de.quantummaid.documaid.domain.markdown.tagBased.MarkdownTagHandler;
import de.quantummaid.documaid.domain.markdown.tagBased.RawMarkdownDirective;
import de.quantummaid.documaid.domain.markdown.tagBased.matching.TrailingMarkdownMatchResult;
import de.quantummaid.documaid.domain.markdown.tagBased.tableOfContents.GithubTableOfContentsMarkdown;
import de.quantummaid.documaid.domain.markdown.tagBased.tableOfContents.TableOfContentsDirective;
import de.quantummaid.documaid.errors.VerificationError;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J4\u0010\n\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001c\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00140\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0015\u001a\u00020\bH\u0016J&\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0017"}, d2={"Lde/quantummaid/documaid/domain/markdown/tagBased/tableOfContents/HugoTableOfContentsMarkdownTagHandler;", "Lde/quantummaid/documaid/domain/markdown/tagBased/MarkdownTagHandler;", "()V", "calculateRangeToReplaceIn", "Lkotlin/ranges/IntRange;", "directive", "Lde/quantummaid/documaid/domain/markdown/tagBased/RawMarkdownDirective;", "oldMarkdown", "", "newMarkdown", "generate", "Lkotlin/Pair;", "Lde/quantummaid/documaid/domain/markdown/tagBased/MarkdownReplacement;", "", "Lde/quantummaid/documaid/errors/VerificationError;", "file", "Lde/quantummaid/documaid/domain/markdown/MarkdownFile;", "project", "Lde/quantummaid/documaid/collecting/structure/Project;", "oldMarkdownToBeReplaced", "Lde/quantummaid/documaid/domain/markdown/tagBased/matching/TrailingMarkdownMatchResult;", "tag", "validate", "documaid"})
public final class HugoTableOfContentsMarkdownTagHandler
implements MarkdownTagHandler {
    @Override
    @NotNull
    public String tag() {
        return TableOfContentsDirective.Companion.getTOC_TAG().toString();
    }

    @Override
    @NotNull
    public Pair<MarkdownReplacement, List<VerificationError>> generate(@NotNull RawMarkdownDirective directive, @NotNull MarkdownFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String newMarkdown = this.newMarkdown(directive);
        Pair<String, TrailingMarkdownMatchResult> pair = this.oldMarkdownToBeReplaced(directive);
        String oldMarkdown = (String)pair.component1();
        IntRange range = this.calculateRangeToReplaceIn(directive, oldMarkdown, newMarkdown);
        MarkdownReplacement markdownReplacement = new MarkdownReplacement(range, oldMarkdown, newMarkdown);
        return new Pair((Object)markdownReplacement, (Object)CollectionsKt.emptyList());
    }

    private final String newMarkdown(RawMarkdownDirective directive) {
        return directive.getCompleteString();
    }

    private final Pair<String, TrailingMarkdownMatchResult> oldMarkdownToBeReplaced(RawMarkdownDirective directive) {
        TrailingMarkdownMatchResult markdownMatchResult = GithubTableOfContentsMarkdown.Companion.startsWithTrailingTableOfContentsMarkdown(directive.getRemainingMarkupFileContent());
        String text = markdownMatchResult.getMatches() ? directive.getCompleteString() + markdownMatchResult.getContent() : directive.getCompleteString();
        return new Pair((Object)text, (Object)markdownMatchResult);
    }

    private final IntRange calculateRangeToReplaceIn(RawMarkdownDirective directive, String oldMarkdown, String newMarkdown) {
        int rangeStart = directive.getRange().getFirst();
        int rangeEnd = rangeStart + Math.max(oldMarkdown.length(), newMarkdown.length());
        return new IntRange(rangeStart, rangeEnd);
    }

    @Override
    @NotNull
    public List<VerificationError> validate(@NotNull RawMarkdownDirective directive, @NotNull MarkdownFile file, @NotNull Project project) {
        List list;
        Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String newMarkdown = this.newMarkdown(directive);
        Pair<String, TrailingMarkdownMatchResult> pair = this.oldMarkdownToBeReplaced(directive);
        String textToBeReplaced = (String)pair.component1();
        if (Intrinsics.areEqual((Object)textToBeReplaced, (Object)newMarkdown) ^ true) {
            VerificationError verificationError = VerificationError.Companion.create("Found [" + this.tag() + "] tag with incorrect TOC", file);
            list = CollectionsKt.listOf((Object)verificationError);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

