/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.domain.markdown.tagBased.link;

import de.quantummaid.documaid.collecting.fastLookup.FileObjectsFastLookUpTable;
import de.quantummaid.documaid.collecting.structure.FileObject;
import de.quantummaid.documaid.collecting.structure.Project;
import de.quantummaid.documaid.collecting.structure.ProjectFile;
import de.quantummaid.documaid.domain.markdown.MarkdownFile;
import de.quantummaid.documaid.domain.markdown.tagBased.DirectiveTag;
import de.quantummaid.documaid.domain.markdown.tagBased.RawMarkdownDirective;
import de.quantummaid.documaid.domain.markdown.tagBased.link.LinkDirectiveOptions;
import de.quantummaid.documaid.errors.DocuMaidException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lde/quantummaid/documaid/domain/markdown/tagBased/link/LinkDirective;", "", "directive", "Lde/quantummaid/documaid/domain/markdown/tagBased/RawMarkdownDirective;", "options", "Lde/quantummaid/documaid/domain/markdown/tagBased/link/LinkDirectiveOptions;", "targetFile", "Lde/quantummaid/documaid/collecting/structure/ProjectFile;", "(Lde/quantummaid/documaid/domain/markdown/tagBased/RawMarkdownDirective;Lde/quantummaid/documaid/domain/markdown/tagBased/link/LinkDirectiveOptions;Lde/quantummaid/documaid/collecting/structure/ProjectFile;)V", "getDirective", "()Lde/quantummaid/documaid/domain/markdown/tagBased/RawMarkdownDirective;", "getOptions", "()Lde/quantummaid/documaid/domain/markdown/tagBased/link/LinkDirectiveOptions;", "getTargetFile", "()Lde/quantummaid/documaid/collecting/structure/ProjectFile;", "Companion", "documaid"})
public final class LinkDirective {
    @NotNull
    private final RawMarkdownDirective directive;
    @NotNull
    private final LinkDirectiveOptions options;
    @NotNull
    private final ProjectFile targetFile;
    @NotNull
    private static final DirectiveTag LINK_TAG;
    public static final Companion Companion;

    @NotNull
    public final RawMarkdownDirective getDirective() {
        return this.directive;
    }

    @NotNull
    public final LinkDirectiveOptions getOptions() {
        return this.options;
    }

    @NotNull
    public final ProjectFile getTargetFile() {
        return this.targetFile;
    }

    private LinkDirective(RawMarkdownDirective directive, LinkDirectiveOptions options, ProjectFile targetFile) {
        this.directive = directive;
        this.options = options;
        this.targetFile = targetFile;
    }

    static {
        Companion = new Companion(null);
        LINK_TAG = new DirectiveTag("Link");
    }

    public /* synthetic */ LinkDirective(RawMarkdownDirective directive, LinkDirectiveOptions options, ProjectFile targetFile, DefaultConstructorMarker $constructor_marker) {
        this(directive, options, targetFile);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lde/quantummaid/documaid/domain/markdown/tagBased/link/LinkDirective$Companion;", "", "()V", "LINK_TAG", "Lde/quantummaid/documaid/domain/markdown/tagBased/DirectiveTag;", "getLINK_TAG", "()Lde/quantummaid/documaid/domain/markdown/tagBased/DirectiveTag;", "create", "Lde/quantummaid/documaid/domain/markdown/tagBased/link/LinkDirective;", "directive", "Lde/quantummaid/documaid/domain/markdown/tagBased/RawMarkdownDirective;", "file", "Lde/quantummaid/documaid/domain/markdown/MarkdownFile;", "project", "Lde/quantummaid/documaid/collecting/structure/Project;", "documaid"})
    public static final class Companion {
        @NotNull
        public final DirectiveTag getLINK_TAG() {
            return LINK_TAG;
        }

        @NotNull
        public final LinkDirective create(@NotNull RawMarkdownDirective directive, @NotNull MarkdownFile file, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            LinkDirectiveOptions options = LinkDirectiveOptions.Companion.create(directive, file);
            Path rootRelativeTargetPath = options.getRootDirRelativePath();
            FileObjectsFastLookUpTable lookUpTable = project.getInformation(FileObjectsFastLookUpTable.Companion.getFILES_LOOKUP_TABLE_KEY());
            if (!lookUpTable.fileObjectExists(rootRelativeTargetPath)) {
                throw (Throwable)DocuMaidException.Companion.aDocuMaidException("Found [" + this.getLINK_TAG() + "] tag to not existing file '" + rootRelativeTargetPath + '\'', file);
            }
            FileObject fileObject = lookUpTable.getFileObject(rootRelativeTargetPath);
            if (fileObject == null) {
                throw new NullPointerException("null cannot be cast to non-null type de.quantummaid.documaid.collecting.structure.ProjectFile");
            }
            ProjectFile targetFile = (ProjectFile)fileObject;
            return new LinkDirective(directive, options, targetFile, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

