/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.preparing.duplicateSnippets;

import de.quantummaid.documaid.collecting.structure.Directory;
import de.quantummaid.documaid.collecting.structure.Project;
import de.quantummaid.documaid.collecting.structure.ProjectFile;
import de.quantummaid.documaid.domain.markdown.tagBased.codeSnippet.CodeSnippetDirective;
import de.quantummaid.documaid.domain.snippet.RawSnippet;
import de.quantummaid.documaid.domain.snippet.SnippetId;
import de.quantummaid.documaid.errors.VerificationError;
import de.quantummaid.documaid.preparing.PreparingVisitor;
import de.quantummaid.documaid.preparing.duplicateSnippets.DuplicateSnippetsChecker;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016R6\u0010\u0003\u001a*\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004j\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/quantummaid/documaid/preparing/duplicateSnippets/DuplicateSnippetsChecker;", "Lde/quantummaid/documaid/preparing/PreparingVisitor;", "()V", "snippetsMap", "Ljava/util/HashMap;", "Lde/quantummaid/documaid/domain/snippet/SnippetId;", "", "Lde/quantummaid/documaid/collecting/structure/ProjectFile;", "Lkotlin/collections/HashMap;", "finishPreparation", "", "Lde/quantummaid/documaid/errors/VerificationError;", "project", "Lde/quantummaid/documaid/collecting/structure/Project;", "prepareFile", "file", "documaid"})
public final class DuplicateSnippetsChecker
implements PreparingVisitor {
    private final HashMap<SnippetId, List<ProjectFile>> snippetsMap = new HashMap();

    @Override
    @NotNull
    public List<VerificationError> prepareFile(@NotNull ProjectFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable $this$forEach$iv = file.snippets();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RawSnippet it = (RawSnippet)element$iv;
            boolean bl = false;
            if (this.snippetsMap.containsKey(it.getId())) {
                List<ProjectFile> list;
                List<ProjectFile> list2 = list = this.snippetsMap.get(it.getId());
                Intrinsics.checkNotNull(list2);
                list2.add(file);
                continue;
            }
            this.snippetsMap.put(it.getId(), CollectionsKt.mutableListOf((Object[])new ProjectFile[]{file}));
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<VerificationError> finishPreparation(@NotNull Project project) {
        void $this$mapTo$iv$iv;
        Map.Entry it;
        Map $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Map $this$filter$iv22 = this.snippetsMap;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv22;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var7_9 = $this$filterTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var7_9.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            it = element$iv$iv = iterator.next();
            boolean bl2 = false;
            if (!(((List)it.getValue()).size() >= 2)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        boolean $this$filter$iv22 = false;
        Map $this$map$iv = MapsKt.toSortedMap((Map)destination$iv$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                SnippetId it = (SnippetId)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getValue());
                it = (SnippetId)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Comparable comparable3 = (Comparable)((Object)it.getValue());
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
            }
        });
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        var7_9 = $this$mapTo$iv$iv;
        bl = false;
        for (Map.Entry item$iv$iv : var7_9.entrySet()) {
            it = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl3 = false;
            Object v = it.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"it.value");
            Iterable $this$sortedBy$iv = (Iterable)v;
            boolean $i$f$sortedBy = false;
            boolean bl4 = false;
            String filesListing2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    ProjectFile projectFile = (ProjectFile)a;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)((Object)projectFile.absolutePath()).toString());
                    projectFile = (ProjectFile)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    String string = ((Object)projectFile.absolutePath()).toString();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                }
            }), (CharSequence)", ", null, null, (int)0, null, (Function1)finishPreparation.3.filesListing.2.INSTANCE, (int)30, null);
            String message2 = "Found [" + CodeSnippetDirective.Companion.getCODE_SNIPPET_TAG() + "] tags with duplicate snippet '" + ((SnippetId)it.getKey()).getValue() + "': " + filesListing2;
            VerificationError verificationError = VerificationError.Companion.createWithoutFileOrigin(message2);
            object.add(verificationError);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void startPreparation(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PreparingVisitor.DefaultImpls.startPreparation(this, project);
    }

    @Override
    @NotNull
    public List<VerificationError> beforeDirectoryPreparing(@NotNull Directory directory, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return PreparingVisitor.DefaultImpls.beforeDirectoryPreparing(this, directory, project);
    }

    @Override
    @NotNull
    public List<VerificationError> afterDirectoryPreparing(@NotNull Directory directory, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return PreparingVisitor.DefaultImpls.afterDirectoryPreparing(this, directory, project);
    }
}

