/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.domain.hugo.documentation;

import de.quantummaid.documaid.collecting.fastLookup.FileObjectsFastLookUpTable;
import de.quantummaid.documaid.collecting.structure.Directory;
import de.quantummaid.documaid.collecting.structure.FileObject;
import de.quantummaid.documaid.collecting.structure.Project;
import de.quantummaid.documaid.collecting.structure.ProjectFile;
import de.quantummaid.documaid.domain.hugo.documentation.DocumentationDirectory;
import de.quantummaid.documaid.domain.hugo.documentation.HugoDocumentationGenerationInformation;
import de.quantummaid.documaid.domain.hugo.documentationWeights.HugoDirectoryWeightPadder;
import de.quantummaid.documaid.domain.markdown.MarkdownFile;
import de.quantummaid.documaid.domain.paths.IndexedPath;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lde/quantummaid/documaid/domain/hugo/documentation/DocumentationMarkdownFile;", "", "file", "Lde/quantummaid/documaid/domain/markdown/MarkdownFile;", "(Lde/quantummaid/documaid/domain/markdown/MarkdownFile;)V", "calculateTargetPath", "", "project", "Lde/quantummaid/documaid/collecting/structure/Project;", "calculateWeight", "fillRemainingLevelsWithZeros", "", "generationInformation", "Lde/quantummaid/documaid/domain/hugo/documentation/HugoDocumentationGenerationInformation;", "getFileIndex", "", "getParent", "Lde/quantummaid/documaid/domain/hugo/documentation/DocumentationDirectory;", "Companion", "documaid"})
public final class DocumentationMarkdownFile {
    private final MarkdownFile file;
    public static final Companion Companion = new Companion(null);

    public final void calculateWeight(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DocumentationDirectory parentDocumentationDirectory = this.getParent(project);
        HugoDocumentationGenerationInformation generationInformation = this.file.getData(HugoDocumentationGenerationInformation.Companion.getDOCUMENTATION_GEN_INFO_KEY());
        int levelWithinDocumentationHierarchy = parentDocumentationDirectory.getLevelWithinDocumentationHierarchy();
        generationInformation.setLevelWithinDocumentation(levelWithinDocumentationHierarchy);
        String parentWeightPrefix = parentDocumentationDirectory.getWeighPrefix();
        int index = this.getFileIndex();
        String paddedIndex = HugoDirectoryWeightPadder.Companion.padIndex(index);
        String fillingZeros = this.fillRemainingLevelsWithZeros(generationInformation, project);
        generationInformation.setWeight(parentWeightPrefix + paddedIndex + fillingZeros);
    }

    public final void calculateTargetPath(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DocumentationDirectory parentDocumentatinDirectory = this.getParent(project);
        Path targetPath = parentDocumentatinDirectory.resolveInTargetPath(this.file.name());
        HugoDocumentationGenerationInformation generationInformation = this.file.getData(HugoDocumentationGenerationInformation.Companion.getDOCUMENTATION_GEN_INFO_KEY());
        generationInformation.setTargetPath(targetPath);
    }

    private final DocumentationDirectory getParent(Project project) {
        Path absolutePath = this.file.absolutePath();
        FileObjectsFastLookUpTable lookUpTable = project.getInformation(FileObjectsFastLookUpTable.Companion.getFILES_LOOKUP_TABLE_KEY());
        Path path = absolutePath.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"absolutePath.parent");
        FileObject parent = lookUpTable.getFileObject(path);
        if (parent != null) {
            return DocumentationDirectory.Companion.aDocumentationDirectory((Directory)parent);
        }
        throw (Throwable)new IllegalArgumentException("Could not obtain parent " + absolutePath.getParent() + " for " + absolutePath);
    }

    private final int getFileIndex() {
        int n;
        Path absolutePath = this.file.absolutePath();
        if (IndexedPath.Companion.isIndexedPath(absolutePath)) {
            IndexedPath indexedPath = IndexedPath.Companion.anIndexedPath(absolutePath);
            n = indexedPath.getIndex();
        } else {
            n = 0;
        }
        return n;
    }

    private final String fillRemainingLevelsWithZeros(HugoDocumentationGenerationInformation generationInformation, Project project) {
        String zeroPadded = HugoDirectoryWeightPadder.Companion.padIndex(0);
        int docuMaxLevel = ((Number)project.getInformation(HugoDocumentationGenerationInformation.Companion.getDOCUMENTATION_MAX_LEVEL())).intValue();
        Integer n = generationInformation.getLevelWithinDocumentation();
        Intrinsics.checkNotNull((Object)n);
        int levelsToFillUp = docuMaxLevel - n;
        return StringsKt.repeat((CharSequence)zeroPadded, (int)levelsToFillUp);
    }

    private DocumentationMarkdownFile(MarkdownFile file) {
        this.file = file;
    }

    public /* synthetic */ DocumentationMarkdownFile(MarkdownFile file, DefaultConstructorMarker $constructor_marker) {
        this(file);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lde/quantummaid/documaid/domain/hugo/documentation/DocumentationMarkdownFile$Companion;", "", "()V", "aDocumentationMarkdownFile", "Lde/quantummaid/documaid/domain/hugo/documentation/DocumentationMarkdownFile;", "file", "Lde/quantummaid/documaid/domain/markdown/MarkdownFile;", "isDocumentationMarkdownFile", "", "Lde/quantummaid/documaid/collecting/structure/ProjectFile;", "documaid"})
    public static final class Companion {
        public final boolean isDocumentationMarkdownFile(@NotNull ProjectFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return file.hasDataFor(HugoDocumentationGenerationInformation.Companion.getDOCUMENTATION_GEN_INFO_KEY());
        }

        @NotNull
        public final DocumentationMarkdownFile aDocumentationMarkdownFile(@NotNull MarkdownFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return new DocumentationMarkdownFile(file, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

