/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.generating;

import de.quantummaid.documaid.collecting.structure.ProjectFile;
import de.quantummaid.documaid.domain.hugo.documentation.HugoDocumentationGenerationInformation;
import de.quantummaid.documaid.domain.markdown.MarkdownFile;
import de.quantummaid.documaid.domain.paths.PathUtilsKt;
import de.quantummaid.documaid.generating.GenerationFlavor;
import de.quantummaid.documaid.processing.ProcessingResult;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lde/quantummaid/documaid/generating/QuantumMaidGenerationFlavor;", "Lde/quantummaid/documaid/generating/GenerationFlavor;", "projectBasePath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "DO_NOT_GENERATE_FILE", "", "getProjectBasePath", "()Ljava/nio/file/Path;", "process", "Lde/quantummaid/documaid/processing/ProcessingResult;", "processingResult", "documaid"})
final class QuantumMaidGenerationFlavor
implements GenerationFlavor {
    private final Void DO_NOT_GENERATE_FILE;
    @NotNull
    private final Path projectBasePath;

    @Override
    @Nullable
    public ProcessingResult process(@NotNull ProcessingResult processingResult) {
        Intrinsics.checkParameterIsNotNull((Object)processingResult, (String)"processingResult");
        ProjectFile file = processingResult.getFile();
        if (file instanceof MarkdownFile) {
            Path relativePath = PathUtilsKt.makeRelativeTo(file, this.projectBasePath);
            if (PathUtilsKt.pathFileNameMatchesFileNameExactly(relativePath, "README.md")) {
            }
            if (PathUtilsKt.pathMatchesFileRegex(relativePath, "README.*?\\.md")) {
                return (ProcessingResult)((Object)this.DO_NOT_GENERATE_FILE);
            }
            if (!file.hasDataFor(HugoDocumentationGenerationInformation.Companion.getDOCUMENTATION_GEN_INFO_KEY())) {
                return (ProcessingResult)((Object)this.DO_NOT_GENERATE_FILE);
            }
            return processingResult;
        }
        return (ProcessingResult)((Object)this.DO_NOT_GENERATE_FILE);
    }

    @NotNull
    public final Path getProjectBasePath() {
        return this.projectBasePath;
    }

    public QuantumMaidGenerationFlavor(@NotNull Path projectBasePath) {
        Intrinsics.checkParameterIsNotNull((Object)projectBasePath, (String)"projectBasePath");
        this.projectBasePath = projectBasePath;
    }
}

