/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.domain.markdown.tagBased.navigation;

import de.quantummaid.documaid.collecting.structure.Project;
import de.quantummaid.documaid.domain.markdown.MarkdownFile;
import de.quantummaid.documaid.domain.markdown.tagBased.MarkdownReplacement;
import de.quantummaid.documaid.domain.markdown.tagBased.MarkdownTagHandler;
import de.quantummaid.documaid.domain.markdown.tagBased.RawMarkdownDirective;
import de.quantummaid.documaid.domain.markdown.tagBased.matching.TrailingMarkdownMatchResult;
import de.quantummaid.documaid.domain.markdown.tagBased.navigation.GithubNavigationMarkdown;
import de.quantummaid.documaid.domain.markdown.tagBased.navigation.NavigationDirective;
import de.quantummaid.documaid.errors.VerificationError;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\b\u0010\u0014\u001a\u00020\u000fH\u0016J\u001c\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00150\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J&\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0017"}, d2={"Lde/quantummaid/documaid/domain/markdown/tagBased/navigation/GithubNavigationMarkdownHandler;", "Lde/quantummaid/documaid/domain/markdown/tagBased/MarkdownTagHandler;", "()V", "generate", "Lkotlin/Pair;", "Lde/quantummaid/documaid/domain/markdown/tagBased/MarkdownReplacement;", "", "Lde/quantummaid/documaid/errors/VerificationError;", "directive", "Lde/quantummaid/documaid/domain/markdown/tagBased/RawMarkdownDirective;", "file", "Lde/quantummaid/documaid/domain/markdown/MarkdownFile;", "project", "Lde/quantummaid/documaid/collecting/structure/Project;", "generateNewMarkdown", "", "rangeToReplaceIn", "Lkotlin/ranges/IntRange;", "markdown", "textToBeReplaced", "tag", "Lde/quantummaid/documaid/domain/markdown/tagBased/matching/TrailingMarkdownMatchResult;", "validate", "documaid"})
public final class GithubNavigationMarkdownHandler
implements MarkdownTagHandler {
    @Override
    @NotNull
    public String tag() {
        return NavigationDirective.Companion.getNAV_TAG().toString();
    }

    @Override
    @NotNull
    public Pair<MarkdownReplacement, List<VerificationError>> generate(@NotNull RawMarkdownDirective directive, @NotNull MarkdownFile file, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)directive, (String)"directive");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String newMarkdown = this.generateNewMarkdown(directive, file, project);
        Pair<String, TrailingMarkdownMatchResult> pair = this.textToBeReplaced(directive);
        String textToBeReplaced = (String)pair.component1();
        IntRange rangeToReplaceIn = this.rangeToReplaceIn(directive, newMarkdown, textToBeReplaced);
        MarkdownReplacement markdownReplacement = new MarkdownReplacement(rangeToReplaceIn, textToBeReplaced, newMarkdown);
        return new Pair((Object)markdownReplacement, (Object)CollectionsKt.emptyList());
    }

    private final Pair<String, TrailingMarkdownMatchResult> textToBeReplaced(RawMarkdownDirective directive) {
        TrailingMarkdownMatchResult matchResult = GithubNavigationMarkdown.Companion.startsWithNavigationMarkdown(directive.getRemainingMarkupFileContent());
        String text = matchResult.getMatches() ? directive.getCompleteString() + matchResult.getContent() : directive.getCompleteString();
        return new Pair((Object)text, (Object)matchResult);
    }

    private final IntRange rangeToReplaceIn(RawMarkdownDirective directive, String markdown, String textToBeReplaced) {
        int endInclusive = directive.startIndex() + Math.max(markdown.length(), textToBeReplaced.length());
        return new IntRange(directive.startIndex(), endInclusive);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<VerificationError> validate(@NotNull RawMarkdownDirective directive, @NotNull MarkdownFile file, @NotNull Project project) {
        boolean navFound;
        void textToBeReplaced;
        Intrinsics.checkParameterIsNotNull((Object)directive, (String)"directive");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String markdown = this.generateNewMarkdown(directive, file, project);
        Pair<String, TrailingMarkdownMatchResult> pair = this.textToBeReplaced(directive);
        String string = (String)pair.component1();
        TrailingMarkdownMatchResult matchResult = (TrailingMarkdownMatchResult)pair.component2();
        return Intrinsics.areEqual((Object)markdown, (Object)textToBeReplaced) ^ true ? ((navFound = matchResult.getMatches()) ? CollectionsKt.listOf((Object)VerificationError.Companion.create("Found [" + this.tag() + "] tag with wrong navigation", file)) : CollectionsKt.listOf((Object)VerificationError.Companion.create("Found [" + this.tag() + "] tag with missing navigation", file))) : CollectionsKt.emptyList();
    }

    private final String generateNewMarkdown(RawMarkdownDirective directive, MarkdownFile file, Project project) {
        NavigationDirective navDirective = NavigationDirective.Companion.create(directive, file, project);
        GithubNavigationMarkdown markdown = navDirective.generateMarkdown();
        return markdown.generateMarkdown(navDirective);
    }
}

