/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.domain.markdown.tagBased.dependency;

import de.quantummaid.documaid.collecting.structure.Project;
import de.quantummaid.documaid.config.DocuMaidConfiguration;
import de.quantummaid.documaid.config.MavenConfiguration;
import de.quantummaid.documaid.domain.markdown.MarkdownFile;
import de.quantummaid.documaid.domain.markdown.tagBased.OptionsString;
import de.quantummaid.documaid.domain.markdown.tagBased.RawMarkdownDirective;
import de.quantummaid.documaid.domain.markdown.tagBased.dependency.DependencyDirective;
import de.quantummaid.documaid.domain.maven.ArtifactId;
import de.quantummaid.documaid.domain.maven.GroupId;
import de.quantummaid.documaid.domain.maven.Scope;
import de.quantummaid.documaid.domain.maven.Version;
import de.quantummaid.documaid.errors.DocuMaidException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lde/quantummaid/documaid/domain/markdown/tagBased/dependency/DependencyDirectiveOptions;", "", "groupId", "Lde/quantummaid/documaid/domain/maven/GroupId;", "artifactId", "Lde/quantummaid/documaid/domain/maven/ArtifactId;", "version", "Lde/quantummaid/documaid/domain/maven/Version;", "scope", "Lde/quantummaid/documaid/domain/maven/Scope;", "(Lde/quantummaid/documaid/domain/maven/GroupId;Lde/quantummaid/documaid/domain/maven/ArtifactId;Lde/quantummaid/documaid/domain/maven/Version;Lde/quantummaid/documaid/domain/maven/Scope;)V", "getArtifactId", "()Lde/quantummaid/documaid/domain/maven/ArtifactId;", "getGroupId", "()Lde/quantummaid/documaid/domain/maven/GroupId;", "getScope", "()Lde/quantummaid/documaid/domain/maven/Scope;", "getVersion", "()Lde/quantummaid/documaid/domain/maven/Version;", "Companion", "documaid"})
public final class DependencyDirectiveOptions {
    @NotNull
    private final GroupId groupId;
    @NotNull
    private final ArtifactId artifactId;
    @NotNull
    private final Version version;
    @Nullable
    private final Scope scope;
    private static final Regex DEPENDENY_OPTIONS_REGEX;
    private static final Regex PROPERTY_VALUE_REGEX;
    public static final Companion Companion;

    @NotNull
    public final GroupId getGroupId() {
        return this.groupId;
    }

    @NotNull
    public final ArtifactId getArtifactId() {
        return this.artifactId;
    }

    @NotNull
    public final Version getVersion() {
        return this.version;
    }

    @Nullable
    public final Scope getScope() {
        return this.scope;
    }

    public DependencyDirectiveOptions(@NotNull GroupId groupId, @NotNull ArtifactId artifactId, @NotNull Version version, @Nullable Scope scope) {
        Intrinsics.checkParameterIsNotNull((Object)groupId, (String)"groupId");
        Intrinsics.checkParameterIsNotNull((Object)artifactId, (String)"artifactId");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.scope = scope;
    }

    static {
        Companion = new Companion(null);
        String string = "\\(? *(?<groupId>groupId(=[^ ]*)?) *(?<artifactId>artifactId(=[^ ]*)?) *(?<version>version(=[^ ]*)?) *(?<scope>scope=[^ ]*)? *\\)?";
        boolean bl = false;
        DEPENDENY_OPTIONS_REGEX = new Regex(string);
        string = "[\\w]+=(?<value>.+)";
        bl = false;
        PROPERTY_VALUE_REGEX = new Regex(string);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0002J\"\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lde/quantummaid/documaid/domain/markdown/tagBased/dependency/DependencyDirectiveOptions$Companion;", "", "()V", "DEPENDENY_OPTIONS_REGEX", "Lkotlin/text/Regex;", "PROPERTY_VALUE_REGEX", "create", "Lde/quantummaid/documaid/domain/markdown/tagBased/dependency/DependencyDirectiveOptions;", "rawMarkdownDirective", "Lde/quantummaid/documaid/domain/markdown/tagBased/RawMarkdownDirective;", "file", "Lde/quantummaid/documaid/domain/markdown/MarkdownFile;", "project", "Lde/quantummaid/documaid/collecting/structure/Project;", "extractArtifactId", "Lde/quantummaid/documaid/domain/maven/ArtifactId;", "matchResult", "Lkotlin/text/MatchResult;", "mavenConfig", "Lde/quantummaid/documaid/config/MavenConfiguration;", "extractGroupId", "Lde/quantummaid/documaid/domain/maven/GroupId;", "extractMandatoryValue", "", "valueName", "extractOptionalValue", "extractScope", "Lde/quantummaid/documaid/domain/maven/Scope;", "extractVersion", "Lde/quantummaid/documaid/domain/maven/Version;", "documaid"})
    public static final class Companion {
        @NotNull
        public final DependencyDirectiveOptions create(@NotNull RawMarkdownDirective rawMarkdownDirective, @NotNull MarkdownFile file, @NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)rawMarkdownDirective, (String)"rawMarkdownDirective");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            MavenConfiguration mavenConfiguration = project.getInformation(DocuMaidConfiguration.Companion.getDOCUMAID_CONFIGURATION_KEY()).getMavenConfiguration();
            OptionsString optionsString = rawMarkdownDirective.getOptionsString();
            MatchResult matchEntire = DEPENDENY_OPTIONS_REGEX.matchEntire((CharSequence)optionsString.getValue());
            if (matchEntire != null) {
                GroupId groupId = this.extractGroupId(matchEntire, mavenConfiguration, file);
                ArtifactId artifactId = this.extractArtifactId(matchEntire, mavenConfiguration, file);
                Version version = this.extractVersion(matchEntire, mavenConfiguration, file);
                Scope scope = this.extractScope(matchEntire);
                return new DependencyDirectiveOptions(groupId, artifactId, version, scope);
            }
            String message2 = "Cannot parse options for [" + DependencyDirective.Companion.getDEPENDENCY_TAG().getValue() + "]: " + optionsString.getValue();
            throw (Throwable)DocuMaidException.Companion.aDocuMaidException(message2, file);
        }

        private final GroupId extractGroupId(MatchResult matchResult, MavenConfiguration mavenConfig, MarkdownFile file) {
            String groupIdString = this.extractMandatoryValue(matchResult, "groupId", file);
            return groupIdString != null ? GroupId.Companion.create(groupIdString) : mavenConfig.getGroupId();
        }

        private final ArtifactId extractArtifactId(MatchResult matchResult, MavenConfiguration mavenConfig, MarkdownFile file) {
            String artifactIdString = this.extractMandatoryValue(matchResult, "artifactId", file);
            return artifactIdString != null ? ArtifactId.Companion.create(artifactIdString) : mavenConfig.getArtifactId();
        }

        private final Version extractVersion(MatchResult matchResult, MavenConfiguration mavenConfig, MarkdownFile file) {
            String versionString = this.extractMandatoryValue(matchResult, "version", file);
            return versionString != null ? Version.Companion.create(versionString) : mavenConfig.getVersion();
        }

        private final Scope extractScope(MatchResult matchResult) {
            String scopeString = this.extractOptionalValue(matchResult, "scope");
            return scopeString != null ? Scope.Companion.create(scopeString) : null;
        }

        private final String extractMandatoryValue(MatchResult matchResult, String valueName, MarkdownFile file) {
            MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)valueName);
            if (matchGroup != null) {
                String string;
                MatchResult propertyValueMatch = PROPERTY_VALUE_REGEX.matchEntire((CharSequence)matchGroup.getValue());
                if (propertyValueMatch != null) {
                    MatchGroup matchGroup2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)propertyValueMatch.getGroups(), (String)"value");
                    if (matchGroup2 == null) {
                        Intrinsics.throwNpe();
                    }
                    string = matchGroup2.getValue();
                } else {
                    string = null;
                }
                return string;
            }
            throw (Throwable)DocuMaidException.Companion.aDocuMaidException('[' + DependencyDirective.Companion.getDEPENDENCY_TAG().getValue() + "] requires '" + valueName + "' to be set in options.", file);
        }

        private final String extractOptionalValue(MatchResult matchResult, String valueName) {
            MatchResult propertyValueMatch;
            MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)valueName);
            if (matchGroup != null && (propertyValueMatch = PROPERTY_VALUE_REGEX.matchEntire((CharSequence)matchGroup.getValue())) != null) {
                MatchGroup matchGroup2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)propertyValueMatch.getGroups(), (String)"value");
                if (matchGroup2 == null) {
                    Intrinsics.throwNpe();
                }
                return matchGroup2.getValue();
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

