/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.collecting;

import de.quantummaid.documaid.collecting.structure.Directory;
import de.quantummaid.documaid.collecting.structure.FileCreator;
import de.quantummaid.documaid.collecting.structure.FileObjectVisitor;
import de.quantummaid.documaid.collecting.structure.ProjectFile;
import de.quantummaid.documaid.collecting.traversaldecision.CollectingTraversalDecision;
import de.quantummaid.documaid.config.DocuMaidConfiguration;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u0014\u001a\u00020\fJ\u001c\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00022\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u001c\u0010\u001a\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00022\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u001c\u0010\u001d\u001a\u00020\u00162\b\u0010\u001e\u001a\u0004\u0018\u00010\u00022\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lde/quantummaid/documaid/collecting/CollectingFileVisitor;", "Ljava/nio/file/SimpleFileVisitor;", "", "docuMaidConfig", "Lde/quantummaid/documaid/config/DocuMaidConfiguration;", "visitors", "", "Lde/quantummaid/documaid/collecting/structure/FileObjectVisitor;", "collectingTraversalDecision", "Lde/quantummaid/documaid/collecting/traversaldecision/CollectingTraversalDecision;", "currentDirectoryStack", "", "Lde/quantummaid/documaid/collecting/structure/Directory;", "(Lde/quantummaid/documaid/config/DocuMaidConfiguration;Ljava/util/List;Lde/quantummaid/documaid/collecting/traversaldecision/CollectingTraversalDecision;Ljava/util/List;)V", "getCollectingTraversalDecision", "()Lde/quantummaid/documaid/collecting/traversaldecision/CollectingTraversalDecision;", "getDocuMaidConfig", "()Lde/quantummaid/documaid/config/DocuMaidConfiguration;", "getVisitors", "()Ljava/util/List;", "getRootDirectory", "postVisitDirectory", "Ljava/nio/file/FileVisitResult;", "dir", "exc", "Ljava/io/IOException;", "preVisitDirectory", "attrs", "Ljava/nio/file/attribute/BasicFileAttributes;", "visitFile", "file", "documaid"})
final class CollectingFileVisitor
extends SimpleFileVisitor<Object> {
    @NotNull
    private final DocuMaidConfiguration docuMaidConfig;
    @NotNull
    private final List<FileObjectVisitor> visitors;
    @NotNull
    private final CollectingTraversalDecision collectingTraversalDecision;
    private final List<Directory> currentDirectoryStack;

    @Override
    @NotNull
    public FileVisitResult preVisitDirectory(@Nullable Object dir, @Nullable BasicFileAttributes attrs) {
        Path path;
        super.preVisitDirectory(dir, attrs);
        Path path2 = path = Paths.get(String.valueOf(dir), new String[0]).toAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"path");
        if (!this.collectingTraversalDecision.shouldDirectoryBeVisited(path2)) {
            return FileVisitResult.SKIP_SUBTREE;
        }
        Directory directory = new Directory(path);
        Collection collection = this.currentDirectoryStack;
        boolean bl = false;
        if (!collection.isEmpty()) {
            Directory parentDirectory = (Directory)CollectionsKt.last(this.currentDirectoryStack);
            parentDirectory.addChild(directory);
        }
        this.currentDirectoryStack.add(directory);
        return FileVisitResult.CONTINUE;
    }

    @Override
    @NotNull
    public FileVisitResult visitFile(@Nullable Object file, @Nullable BasicFileAttributes attrs) {
        Path path;
        super.visitFile(file, attrs);
        Path path2 = path = Paths.get(String.valueOf(file), new String[0]).toAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"path");
        if (!this.collectingTraversalDecision.shouldFileBeVisited(path2)) {
            return FileVisitResult.CONTINUE;
        }
        Directory directory = (Directory)CollectionsKt.last(this.currentDirectoryStack);
        ProjectFile fileObject = FileCreator.Companion.create(path, this.docuMaidConfig);
        directory.addChild(fileObject);
        Iterable $this$forEach$iv = this.visitors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileObjectVisitor it = (FileObjectVisitor)element$iv;
            boolean bl = false;
            it.fileVisited(fileObject);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    @NotNull
    public FileVisitResult postVisitDirectory(@Nullable Object dir, @Nullable IOException exc) {
        super.postVisitDirectory(dir, exc);
        Directory directory = (Directory)CollectionsKt.last(this.currentDirectoryStack);
        if (this.currentDirectoryStack.size() > 1) {
            this.currentDirectoryStack.remove(CollectionsKt.getLastIndex(this.currentDirectoryStack));
        }
        Iterable $this$forEach$iv = this.visitors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileObjectVisitor it = (FileObjectVisitor)element$iv;
            boolean bl = false;
            it.directoryVisited(directory);
        }
        return FileVisitResult.CONTINUE;
    }

    @NotNull
    public final Directory getRootDirectory() {
        return (Directory)CollectionsKt.first(this.currentDirectoryStack);
    }

    @NotNull
    public final DocuMaidConfiguration getDocuMaidConfig() {
        return this.docuMaidConfig;
    }

    @NotNull
    public final List<FileObjectVisitor> getVisitors() {
        return this.visitors;
    }

    @NotNull
    public final CollectingTraversalDecision getCollectingTraversalDecision() {
        return this.collectingTraversalDecision;
    }

    public CollectingFileVisitor(@NotNull DocuMaidConfiguration docuMaidConfig, @NotNull List<? extends FileObjectVisitor> visitors, @NotNull CollectingTraversalDecision collectingTraversalDecision, @NotNull List<Directory> currentDirectoryStack) {
        Intrinsics.checkParameterIsNotNull((Object)docuMaidConfig, (String)"docuMaidConfig");
        Intrinsics.checkParameterIsNotNull(visitors, (String)"visitors");
        Intrinsics.checkParameterIsNotNull((Object)collectingTraversalDecision, (String)"collectingTraversalDecision");
        Intrinsics.checkParameterIsNotNull(currentDirectoryStack, (String)"currentDirectoryStack");
        this.docuMaidConfig = docuMaidConfig;
        this.visitors = visitors;
        this.collectingTraversalDecision = collectingTraversalDecision;
        this.currentDirectoryStack = currentDirectoryStack;
    }

    public /* synthetic */ CollectingFileVisitor(DocuMaidConfiguration docuMaidConfiguration, List list, CollectingTraversalDecision collectingTraversalDecision, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            boolean bl = false;
            list2 = new ArrayList();
        }
        this(docuMaidConfiguration, list, collectingTraversalDecision, list2);
    }
}

