/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.domain.markdown.tagBased.archetype;

import de.quantummaid.documaid.collecting.structure.Project;
import de.quantummaid.documaid.config.DocuMaidConfiguration;
import de.quantummaid.documaid.config.MavenConfiguration;
import de.quantummaid.documaid.domain.markdown.MarkdownFile;
import de.quantummaid.documaid.domain.markdown.tagBased.OptionsString;
import de.quantummaid.documaid.domain.markdown.tagBased.RawMarkdownDirective;
import de.quantummaid.documaid.domain.markdown.tagBased.archetype.Archetype;
import de.quantummaid.documaid.domain.markdown.tagBased.archetype.ArchetypeDirective;
import de.quantummaid.documaid.domain.maven.ArtifactId;
import de.quantummaid.documaid.domain.maven.GroupId;
import de.quantummaid.documaid.domain.maven.Packaging;
import de.quantummaid.documaid.domain.maven.Version;
import de.quantummaid.documaid.domain.os.OsType;
import de.quantummaid.documaid.errors.DocuMaidException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lde/quantummaid/documaid/domain/markdown/tagBased/archetype/ArchetypeDirectiveOptions;", "", "archetype", "Lde/quantummaid/documaid/domain/markdown/tagBased/archetype/Archetype;", "osType", "Lde/quantummaid/documaid/domain/os/OsType;", "(Lde/quantummaid/documaid/domain/markdown/tagBased/archetype/Archetype;Lde/quantummaid/documaid/domain/os/OsType;)V", "getArchetype", "()Lde/quantummaid/documaid/domain/markdown/tagBased/archetype/Archetype;", "getOsType", "()Lde/quantummaid/documaid/domain/os/OsType;", "Companion", "documaid"})
public final class ArchetypeDirectiveOptions {
    @NotNull
    private final Archetype archetype;
    @NotNull
    private final OsType osType;
    private static final Regex ARCHETYPE_OPTIONS_REGEX;
    private static final Regex PROPERTY_VALUE_REGEX;
    public static final Companion Companion;

    @NotNull
    public final Archetype getArchetype() {
        return this.archetype;
    }

    @NotNull
    public final OsType getOsType() {
        return this.osType;
    }

    public ArchetypeDirectiveOptions(@NotNull Archetype archetype, @NotNull OsType osType) {
        Intrinsics.checkParameterIsNotNull((Object)archetype, (String)"archetype");
        Intrinsics.checkParameterIsNotNull((Object)((Object)osType), (String)"osType");
        this.archetype = archetype;
        this.osType = osType;
    }

    static {
        Companion = new Companion(null);
        String string = "\\(? *(?<archetypeGroupId>archetypeGroupId(=[^ ]*)?) *(?<archetypeArtifactId>archetypeArtifactId(=[^ ]*)?) *(?<archetypeVersion>archetypeVersion(=[^ ]*)?) *(?<groupId>groupId=[^ ]*) *(?<artifactId>artifactId=[^ ]*) *(?<version>version=[^ ]*) *(?<packaging>packaging=[^ ]*) *(?<os>os=[^ ]*)? *\\)?";
        boolean bl = false;
        ARCHETYPE_OPTIONS_REGEX = new Regex(string);
        string = "[\\w]+=(?<value>.+)";
        bl = false;
        PROPERTY_VALUE_REGEX = new Regex(string);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ,\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010 \u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020!2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\"\u0010#\u001a\u0004\u0018\u00010!2\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020!2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010$\u001a\u0004\u0018\u00010!2\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020!H\u0002J\u0010\u0010%\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0013H\u0002J\u0018\u0010&\u001a\u00020'2\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010(\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lde/quantummaid/documaid/domain/markdown/tagBased/archetype/ArchetypeDirectiveOptions$Companion;", "", "()V", "ARCHETYPE_OPTIONS_REGEX", "Lkotlin/text/Regex;", "PROPERTY_VALUE_REGEX", "create", "Lde/quantummaid/documaid/domain/markdown/tagBased/archetype/ArchetypeDirectiveOptions;", "rawMarkdownDirective", "Lde/quantummaid/documaid/domain/markdown/tagBased/RawMarkdownDirective;", "file", "Lde/quantummaid/documaid/domain/markdown/MarkdownFile;", "project", "Lde/quantummaid/documaid/collecting/structure/Project;", "extractArchetype", "Lkotlin/Pair;", "Lde/quantummaid/documaid/domain/os/OsType;", "Lde/quantummaid/documaid/domain/markdown/tagBased/archetype/Archetype;", "matchEntire", "Lkotlin/text/MatchResult;", "mavenConfiguration", "Lde/quantummaid/documaid/config/MavenConfiguration;", "extractArchetypeArtifactId", "Lde/quantummaid/documaid/domain/maven/ArtifactId;", "matchResult", "mavenConfig", "extractArchetypeGroupId", "Lde/quantummaid/documaid/domain/maven/GroupId;", "extractArchetypeVersion", "Lde/quantummaid/documaid/domain/maven/Version;", "extractArtifactId", "extractGroupId", "extractMandatoryPropertyWithMandatoryValue", "", "valueName", "extractMandatoryPropertyWithOptionalValue", "extractOptionalValue", "extractOsType", "extractPackaging", "Lde/quantummaid/documaid/domain/maven/Packaging;", "extractVersion", "documaid"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ArchetypeDirectiveOptions create(@NotNull RawMarkdownDirective rawMarkdownDirective, @NotNull MarkdownFile file, @NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)rawMarkdownDirective, (String)"rawMarkdownDirective");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            MavenConfiguration mavenConfiguration = project.getInformation(DocuMaidConfiguration.Companion.getDOCUMAID_CONFIGURATION_KEY()).getMavenConfiguration();
            OptionsString optionsString = rawMarkdownDirective.getOptionsString();
            MatchResult matchEntire = ARCHETYPE_OPTIONS_REGEX.matchEntire((CharSequence)optionsString.getValue());
            if (matchEntire != null) {
                void osType;
                Pair<OsType, Archetype> pair = this.extractArchetype(matchEntire, mavenConfiguration, file);
                OsType osType2 = (OsType)((Object)pair.component1());
                Archetype archetype = (Archetype)pair.component2();
                return new ArchetypeDirectiveOptions(archetype, (OsType)osType);
            }
            String message2 = "Cannot parse options for [" + ArchetypeDirective.Companion.getARCHETYPE_TAG().getValue() + "]: " + optionsString.getValue();
            throw (Throwable)DocuMaidException.Companion.aDocuMaidException(message2, file);
        }

        private final Pair<OsType, Archetype> extractArchetype(MatchResult matchEntire, MavenConfiguration mavenConfiguration, MarkdownFile file) {
            GroupId archetypeGroupId = this.extractArchetypeGroupId(matchEntire, mavenConfiguration, file);
            ArtifactId archetypeArtifactId = this.extractArchetypeArtifactId(matchEntire, mavenConfiguration, file);
            Version archetypeVersion = this.extractArchetypeVersion(matchEntire, mavenConfiguration, file);
            GroupId groupId = this.extractGroupId(matchEntire, file);
            ArtifactId artifactId = this.extractArtifactId(matchEntire, file);
            Version version = this.extractVersion(matchEntire, file);
            Packaging packaging = this.extractPackaging(matchEntire, file);
            OsType osType = this.extractOsType(matchEntire);
            Archetype archetype = new Archetype(archetypeGroupId, archetypeArtifactId, archetypeVersion, groupId, artifactId, version, packaging);
            return new Pair((Object)osType, (Object)archetype);
        }

        private final GroupId extractArchetypeGroupId(MatchResult matchResult, MavenConfiguration mavenConfig, MarkdownFile file) {
            String groupName = "archetypeGroupId";
            String groupIdString = this.extractMandatoryPropertyWithOptionalValue(matchResult, groupName, file);
            return groupIdString != null ? GroupId.Companion.create(groupIdString) : mavenConfig.getGroupId();
        }

        private final ArtifactId extractArchetypeArtifactId(MatchResult matchResult, MavenConfiguration mavenConfig, MarkdownFile file) {
            String groupName = "archetypeArtifactId";
            String artifactIdString = this.extractMandatoryPropertyWithOptionalValue(matchResult, groupName, file);
            return artifactIdString != null ? ArtifactId.Companion.create(artifactIdString) : mavenConfig.getArtifactId();
        }

        private final Version extractArchetypeVersion(MatchResult matchResult, MavenConfiguration mavenConfig, MarkdownFile file) {
            String groupName = "archetypeVersion";
            String versionString = this.extractMandatoryPropertyWithOptionalValue(matchResult, groupName, file);
            return versionString != null ? Version.Companion.create(versionString) : mavenConfig.getVersion();
        }

        private final GroupId extractGroupId(MatchResult matchResult, MarkdownFile file) {
            String groupIdString = this.extractMandatoryPropertyWithMandatoryValue(matchResult, "groupId", file);
            return GroupId.Companion.create(groupIdString);
        }

        private final ArtifactId extractArtifactId(MatchResult matchResult, MarkdownFile file) {
            String artifactIdString = this.extractMandatoryPropertyWithMandatoryValue(matchResult, "artifactId", file);
            return ArtifactId.Companion.create(artifactIdString);
        }

        private final Version extractVersion(MatchResult matchResult, MarkdownFile file) {
            String versionString = this.extractMandatoryPropertyWithMandatoryValue(matchResult, "version", file);
            return Version.Companion.create(versionString);
        }

        private final Packaging extractPackaging(MatchResult matchResult, MarkdownFile file) {
            String packagingString = this.extractMandatoryPropertyWithMandatoryValue(matchResult, "packaging", file);
            return Packaging.Companion.create(packagingString);
        }

        private final OsType extractOsType(MatchResult matchResult) {
            String osTypeString = this.extractOptionalValue(matchResult, "os");
            return osTypeString != null ? OsType.Companion.forString(osTypeString) : OsType.LINUX;
        }

        private final String extractMandatoryPropertyWithOptionalValue(MatchResult matchResult, String valueName, MarkdownFile file) {
            MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)valueName);
            if (matchGroup != null) {
                String string;
                MatchResult propertyValueMatch = PROPERTY_VALUE_REGEX.matchEntire((CharSequence)matchGroup.getValue());
                if (propertyValueMatch != null) {
                    MatchGroup matchGroup2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)propertyValueMatch.getGroups(), (String)"value");
                    if (matchGroup2 == null) {
                        Intrinsics.throwNpe();
                    }
                    string = matchGroup2.getValue();
                } else {
                    string = null;
                }
                return string;
            }
            throw (Throwable)DocuMaidException.Companion.aDocuMaidException('[' + ArchetypeDirective.Companion.getARCHETYPE_TAG().getValue() + "] requires '" + valueName + "' to be set in options.", file);
        }

        private final String extractMandatoryPropertyWithMandatoryValue(MatchResult matchResult, String valueName, MarkdownFile file) {
            MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)valueName);
            String exceptionMessage = '[' + ArchetypeDirective.Companion.getARCHETYPE_TAG().getValue() + "] requires '" + valueName + "' to be set in options.";
            if (matchGroup != null) {
                MatchGroup matchGroup2;
                MatchResult propertyValueMatch = PROPERTY_VALUE_REGEX.matchEntire((CharSequence)matchGroup.getValue());
                if (propertyValueMatch != null) {
                    matchGroup2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)propertyValueMatch.getGroups(), (String)"value");
                    if (matchGroup2 == null) {
                        Intrinsics.throwNpe();
                    }
                } else {
                    throw (Throwable)DocuMaidException.Companion.aDocuMaidException(exceptionMessage, file);
                }
                return matchGroup2.getValue();
            }
            throw (Throwable)DocuMaidException.Companion.aDocuMaidException(exceptionMessage, file);
        }

        private final String extractOptionalValue(MatchResult matchResult, String valueName) {
            MatchResult propertyValueMatch;
            MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)valueName);
            if (matchGroup != null && (propertyValueMatch = PROPERTY_VALUE_REGEX.matchEntire((CharSequence)matchGroup.getValue())) != null) {
                MatchGroup matchGroup2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)propertyValueMatch.getGroups(), (String)"value");
                if (matchGroup2 == null) {
                    Intrinsics.throwNpe();
                }
                return matchGroup2.getValue();
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

