/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.domain.hugo.documentation;

import de.quantummaid.documaid.collecting.structure.Directory;
import de.quantummaid.documaid.collecting.structure.Project;
import de.quantummaid.documaid.collecting.structure.ProjectFile;
import de.quantummaid.documaid.config.Goal;
import de.quantummaid.documaid.domain.hugo.documentation.DocumentationDirectory;
import de.quantummaid.documaid.domain.hugo.documentation.DocumentationMarkdownFile;
import de.quantummaid.documaid.domain.markdown.MarkdownFile;
import de.quantummaid.documaid.processing.ProcessingResult;
import de.quantummaid.documaid.processing.ProcessingVisitorAdapter;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J \u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u0012"}, d2={"Lde/quantummaid/documaid/domain/hugo/documentation/HugoDocumentationProcessor;", "Lde/quantummaid/documaid/processing/ProcessingVisitorAdapter;", "()V", "afterDirectoryProcessing", "", "directory", "Lde/quantummaid/documaid/collecting/structure/Directory;", "project", "Lde/quantummaid/documaid/collecting/structure/Project;", "goal", "Lde/quantummaid/documaid/config/Goal;", "directoryProcessingResults", "", "Lde/quantummaid/documaid/processing/ProcessingResult;", "beforeDirectoryProcessing", "beforeFileProcessing", "file", "Lde/quantummaid/documaid/collecting/structure/ProjectFile;", "documaid"})
public final class HugoDocumentationProcessor
extends ProcessingVisitorAdapter {
    @Override
    public void beforeDirectoryProcessing(@NotNull Directory directory, @NotNull Project project, @NotNull Goal goal) {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)goal), (String)"goal");
        if (DocumentationDirectory.Companion.isDocumentationDirectory(directory)) {
            DocumentationDirectory documentationDirectory = DocumentationDirectory.Companion.aDocumentationDirectory(directory);
            documentationDirectory.calculateTargetPath(project);
            documentationDirectory.calculateWeight(project);
        }
    }

    @Override
    public void beforeFileProcessing(@NotNull ProjectFile file, @NotNull Project project, @NotNull Goal goal) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)goal), (String)"goal");
        if (DocumentationMarkdownFile.Companion.isDocumentationMarkdownFile(file)) {
            DocumentationMarkdownFile documentationMarkdownFile = DocumentationMarkdownFile.Companion.aDocumentationMarkdownFile((MarkdownFile)file);
            documentationMarkdownFile.calculateTargetPath(project);
            documentationMarkdownFile.calculateWeight(project);
        }
    }

    @Override
    public void afterDirectoryProcessing(@NotNull Directory directory, @NotNull Project project, @NotNull Goal goal, @NotNull List<ProcessingResult> directoryProcessingResults) {
        DocumentationDirectory documentationDirectory;
        ProcessingResult processingResultIfFileCreated;
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)goal), (String)"goal");
        Intrinsics.checkParameterIsNotNull(directoryProcessingResults, (String)"directoryProcessingResults");
        if (DocumentationDirectory.Companion.isDocumentationDirectory(directory) && (processingResultIfFileCreated = (documentationDirectory = DocumentationDirectory.Companion.aDocumentationDirectory(directory)).generateHugoIndexFileIfNotPresent()) != null) {
            directoryProcessingResults.add(processingResultIfFileCreated);
        }
    }
}

