/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.domain.paths;

import de.quantummaid.documaid.collecting.structure.Directory;
import de.quantummaid.documaid.collecting.structure.Project;
import de.quantummaid.documaid.collecting.structure.ProjectFile;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001\u001a\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e\u001a\u0016\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e\u001a\u0016\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u000e\u001a\u0016\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u000e\u001a\u000e\u0010\u0015\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0001\u00a8\u0006\u0016"}, d2={"makeRelativeTo", "Ljava/nio/file/Path;", "directory", "Lde/quantummaid/documaid/collecting/structure/Directory;", "project", "Lde/quantummaid/documaid/collecting/structure/Project;", "projectFile", "Lde/quantummaid/documaid/collecting/structure/ProjectFile;", "rootDir", "absolutePath", "pathFileNameMatchesFileNameExactly", "", "path", "fileName", "", "pathMatchesFileNameExactly", "pathMatchesFileRegex", "fileNameRegex", "pathUnderTopLevelDirectory", "projectRelativePath", "directoryName", "stripTopLevelDirectoryFromRelativePath", "documaid"})
public final class PathUtilsKt {
    @NotNull
    public static final Path makeRelativeTo(@NotNull Directory directory, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Path dirPath = directory.absolutePath();
        Path rootDir = project.getRootDirectory().absolutePath();
        Path path = rootDir.relativize(dirPath);
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"rootDir.relativize(dirPath)");
        return path;
    }

    @NotNull
    public static final Path makeRelativeTo(@NotNull ProjectFile projectFile, @NotNull Path rootDir) {
        Intrinsics.checkParameterIsNotNull((Object)projectFile, (String)"projectFile");
        Intrinsics.checkParameterIsNotNull((Object)rootDir, (String)"rootDir");
        Path dirPath = projectFile.absolutePath();
        Path path = rootDir.relativize(dirPath);
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"rootDir.relativize(dirPath)");
        return path;
    }

    @NotNull
    public static final Path makeRelativeTo(@NotNull Path absolutePath, @NotNull Path rootDir) {
        Intrinsics.checkParameterIsNotNull((Object)absolutePath, (String)"absolutePath");
        Intrinsics.checkParameterIsNotNull((Object)rootDir, (String)"rootDir");
        Path path = rootDir.relativize(absolutePath);
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"rootDir.relativize(absolutePath)");
        return path;
    }

    public static final boolean pathUnderTopLevelDirectory(@NotNull Path projectRelativePath, @NotNull String directoryName) {
        Intrinsics.checkParameterIsNotNull((Object)projectRelativePath, (String)"projectRelativePath");
        Intrinsics.checkParameterIsNotNull((Object)directoryName, (String)"directoryName");
        return StringsKt.endsWith$default((String)directoryName, (String)"/", (boolean)false, (int)2, null) ? projectRelativePath.startsWith(directoryName) : projectRelativePath.startsWith(directoryName + '/');
    }

    @NotNull
    public static final Path stripTopLevelDirectoryFromRelativePath(@NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Path rootDirectory = path.getName(0);
        Path path2 = rootDirectory.relativize(path);
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"rootDirectory.relativize(path)");
        return path2;
    }

    public static final boolean pathMatchesFileNameExactly(@NotNull Path path, @NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        return Intrinsics.areEqual((Object)((Object)path.getFileName()).toString(), (Object)fileName);
    }

    public static final boolean pathFileNameMatchesFileNameExactly(@NotNull Path path, @NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        return Intrinsics.areEqual((Object)((Object)path).toString(), (Object)fileName);
    }

    public static final boolean pathMatchesFileRegex(@NotNull Path path, @NotNull String fileNameRegex) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)fileNameRegex, (String)"fileNameRegex");
        if (path.getNameCount() == 1) {
            Regex regex = new Regex(fileNameRegex);
            bl = regex.matches((CharSequence)((Object)path).toString());
        } else {
            bl = false;
        }
        return bl;
    }
}

