/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.domain.hugo.documentation;

import de.quantummaid.documaid.collecting.structure.Directory;
import de.quantummaid.documaid.collecting.structure.Project;
import de.quantummaid.documaid.domain.hugo.documentation.AbstractDocumentationDirectory;
import de.quantummaid.documaid.domain.hugo.documentation.DocumentationDirectory;
import de.quantummaid.documaid.domain.hugo.documentation.HugoDocumentationGenerationInformation;
import de.quantummaid.documaid.domain.hugo.documentationWeights.HugoDirectoryWeightPadder;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016\u00a8\u0006\u000f"}, d2={"Lde/quantummaid/documaid/domain/hugo/documentation/NormalDocumentationDirectory;", "Lde/quantummaid/documaid/domain/hugo/documentation/AbstractDocumentationDirectory;", "directory", "Lde/quantummaid/documaid/collecting/structure/Directory;", "(Lde/quantummaid/documaid/collecting/structure/Directory;)V", "calculateTargetPath", "", "project", "Lde/quantummaid/documaid/collecting/structure/Project;", "calculateWeight", "getWeighPrefix", "", "resolveInTargetPath", "Ljava/nio/file/Path;", "name", "documaid"})
final class NormalDocumentationDirectory
extends AbstractDocumentationDirectory {
    @Override
    public void calculateTargetPath(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        DocumentationDirectory parentDocumentationDirectory = this.getParent(project);
        Path targetPath = parentDocumentationDirectory.resolveInTargetPath(this.getDirectory().name());
        HugoDocumentationGenerationInformation generationInformation = this.getDirectory().getData(HugoDocumentationGenerationInformation.Companion.getDOCUMENTATION_GEN_INFO_KEY());
        generationInformation.setTargetPath(targetPath);
    }

    @Override
    public void calculateWeight(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        DocumentationDirectory parentDocumentationDirectory = this.getParent(project);
        HugoDocumentationGenerationInformation generationInformation = this.getDirectory().getData(HugoDocumentationGenerationInformation.Companion.getDOCUMENTATION_GEN_INFO_KEY());
        String parentWeightPrefix = parentDocumentationDirectory.getWeighPrefix();
        int index = this.getFileIndex(generationInformation);
        String paddedIndex = HugoDirectoryWeightPadder.Companion.padIndex(index);
        generationInformation.setWeightPrefix(parentWeightPrefix + paddedIndex);
        String fillingZeros = this.fillRemainingLevelsWithZeros(generationInformation, project);
        generationInformation.setWeight(parentWeightPrefix + paddedIndex + fillingZeros);
    }

    @Override
    @NotNull
    public String getWeighPrefix() {
        HugoDocumentationGenerationInformation generationInformation = this.getDirectory().getData(HugoDocumentationGenerationInformation.Companion.getDOCUMENTATION_GEN_INFO_KEY());
        Path absolutePath = this.getDirectory().absolutePath();
        String string = generationInformation.getWeightPrefix();
        if (string == null) {
            throw (Throwable)new IllegalArgumentException("Weight prefix for directory " + absolutePath + " was not generated.");
        }
        return string;
    }

    @Override
    @NotNull
    public Path resolveInTargetPath(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        HugoDocumentationGenerationInformation generationInformation = this.getDirectory().getData(HugoDocumentationGenerationInformation.Companion.getDOCUMENTATION_GEN_INFO_KEY());
        Path path = generationInformation.getTargetPath();
        if (path == null) {
            throw (Throwable)new IllegalStateException("Can not resolve target path, because own target path has not been set in " + this.getDirectory().absolutePath());
        }
        Path targetPath = path;
        Path path2 = targetPath.resolve(name);
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"targetPath.resolve(name)");
        return path2;
    }

    public NormalDocumentationDirectory(@NotNull Directory directory) {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        super(directory);
    }
}

