/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.domain.markdown.tagBased.codeSnippet;

import de.quantummaid.documaid.collecting.fastLookup.FileObjectsFastLookUpTable;
import de.quantummaid.documaid.collecting.snippets.CodeSnippetsLookupTable;
import de.quantummaid.documaid.collecting.structure.FileObject;
import de.quantummaid.documaid.collecting.structure.Project;
import de.quantummaid.documaid.collecting.structure.ProjectFile;
import de.quantummaid.documaid.domain.java.JavaFile;
import de.quantummaid.documaid.domain.markdown.MarkdownCodeSection;
import de.quantummaid.documaid.domain.markdown.MarkdownFile;
import de.quantummaid.documaid.domain.markdown.tagBased.DirectiveTag;
import de.quantummaid.documaid.domain.markdown.tagBased.RawMarkdownDirective;
import de.quantummaid.documaid.domain.markdown.tagBased.codeSnippet.CodeSnippet;
import de.quantummaid.documaid.domain.markdown.tagBased.codeSnippet.CodeSnippetDirectiveOptions;
import de.quantummaid.documaid.domain.markdown.tagBased.codeSnippet.CodeSnippetMarkdown;
import de.quantummaid.documaid.domain.snippet.RawSnippet;
import de.quantummaid.documaid.domain.snippet.SnippetId;
import de.quantummaid.documaid.domain.unclassifiedFile.UnclassifiedFile;
import de.quantummaid.documaid.domain.xml.XmlFile;
import de.quantummaid.documaid.errors.DocuMaidException;
import de.quantummaid.documaid.io.FileReaderKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lde/quantummaid/documaid/domain/markdown/tagBased/codeSnippet/CodeSnippetDirective;", "", "rawMarkdownDirective", "Lde/quantummaid/documaid/domain/markdown/tagBased/RawMarkdownDirective;", "options", "Lde/quantummaid/documaid/domain/markdown/tagBased/codeSnippet/CodeSnippetDirectiveOptions;", "codeSnippetMarkdown", "Lde/quantummaid/documaid/domain/markdown/tagBased/codeSnippet/CodeSnippetMarkdown;", "(Lde/quantummaid/documaid/domain/markdown/tagBased/RawMarkdownDirective;Lde/quantummaid/documaid/domain/markdown/tagBased/codeSnippet/CodeSnippetDirectiveOptions;Lde/quantummaid/documaid/domain/markdown/tagBased/codeSnippet/CodeSnippetMarkdown;)V", "getOptions", "()Lde/quantummaid/documaid/domain/markdown/tagBased/codeSnippet/CodeSnippetDirectiveOptions;", "getRawMarkdownDirective", "()Lde/quantummaid/documaid/domain/markdown/tagBased/RawMarkdownDirective;", "generateMarkdown", "", "Companion", "documaid"})
public final class CodeSnippetDirective {
    @NotNull
    private final RawMarkdownDirective rawMarkdownDirective;
    @NotNull
    private final CodeSnippetDirectiveOptions options;
    private final CodeSnippetMarkdown codeSnippetMarkdown;
    @NotNull
    private static final DirectiveTag CODE_SNIPPET_TAG;
    public static final Companion Companion;

    @NotNull
    public final String generateMarkdown() {
        return this.rawMarkdownDirective.getCompleteString() + '\n' + this.codeSnippetMarkdown.getMarkdownCodeSection().getContent();
    }

    @NotNull
    public final RawMarkdownDirective getRawMarkdownDirective() {
        return this.rawMarkdownDirective;
    }

    @NotNull
    public final CodeSnippetDirectiveOptions getOptions() {
        return this.options;
    }

    public CodeSnippetDirective(@NotNull RawMarkdownDirective rawMarkdownDirective, @NotNull CodeSnippetDirectiveOptions options, @NotNull CodeSnippetMarkdown codeSnippetMarkdown) {
        Intrinsics.checkParameterIsNotNull((Object)rawMarkdownDirective, (String)"rawMarkdownDirective");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Intrinsics.checkParameterIsNotNull((Object)codeSnippetMarkdown, (String)"codeSnippetMarkdown");
        this.rawMarkdownDirective = rawMarkdownDirective;
        this.options = options;
        this.codeSnippetMarkdown = codeSnippetMarkdown;
    }

    static {
        Companion = new Companion(null);
        CODE_SNIPPET_TAG = new DirectiveTag("CodeSnippet");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J(\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lde/quantummaid/documaid/domain/markdown/tagBased/codeSnippet/CodeSnippetDirective$Companion;", "", "()V", "CODE_SNIPPET_TAG", "Lde/quantummaid/documaid/domain/markdown/tagBased/DirectiveTag;", "getCODE_SNIPPET_TAG", "()Lde/quantummaid/documaid/domain/markdown/tagBased/DirectiveTag;", "create", "Lde/quantummaid/documaid/domain/markdown/tagBased/codeSnippet/CodeSnippetDirective;", "rawMarkdownDirective", "Lde/quantummaid/documaid/domain/markdown/tagBased/RawMarkdownDirective;", "file", "Lde/quantummaid/documaid/domain/markdown/MarkdownFile;", "project", "Lde/quantummaid/documaid/collecting/structure/Project;", "loadCode", "Lde/quantummaid/documaid/domain/markdown/tagBased/codeSnippet/CodeSnippetMarkdown;", "options", "Lde/quantummaid/documaid/domain/markdown/tagBased/codeSnippet/CodeSnippetDirectiveOptions;", "loadCompleteFile", "path", "Ljava/nio/file/Path;", "loadSnippetCode", "snippetId", "Lde/quantummaid/documaid/domain/snippet/SnippetId;", "documaid"})
    public static final class Companion {
        @NotNull
        public final DirectiveTag getCODE_SNIPPET_TAG() {
            return CODE_SNIPPET_TAG;
        }

        @NotNull
        public final CodeSnippetDirective create(@NotNull RawMarkdownDirective rawMarkdownDirective, @NotNull MarkdownFile file, @NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)rawMarkdownDirective, (String)"rawMarkdownDirective");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            CodeSnippetDirectiveOptions options = CodeSnippetDirectiveOptions.Companion.create(rawMarkdownDirective, file);
            CodeSnippetMarkdown codeSnippetMarkdown = this.loadCode(options, file, project, rawMarkdownDirective);
            return new CodeSnippetDirective(rawMarkdownDirective, options, codeSnippetMarkdown);
        }

        private final CodeSnippetMarkdown loadCode(CodeSnippetDirectiveOptions options, MarkdownFile file, Project project, RawMarkdownDirective rawMarkdownDirective) {
            CodeSnippetMarkdown codeSnippetMarkdown;
            if (options.getSnippetId() != null) {
                codeSnippetMarkdown = this.loadSnippetCode(options.getSnippetId(), file, project, rawMarkdownDirective);
            } else if (options.getFilePath() != null) {
                codeSnippetMarkdown = this.loadCompleteFile(options.getFilePath(), file, rawMarkdownDirective);
            } else {
                String message2 = "" + '[' + this.getCODE_SNIPPET_TAG() + "] could not handle config without snippetId or path";
                throw (Throwable)DocuMaidException.Companion.aDocuMaidException(message2, file);
            }
            return codeSnippetMarkdown;
        }

        private final CodeSnippetMarkdown loadSnippetCode(SnippetId snippetId, MarkdownFile file, Project project, RawMarkdownDirective rawMarkdownDirective) {
            RawSnippet rawSnippet;
            CodeSnippetsLookupTable snippetsLookupTable = project.getInformation(CodeSnippetsLookupTable.Companion.getSNIPPETS_LOOKUP_TABLE_KEY());
            if (!snippetsLookupTable.uniqueSnippetExists(snippetId)) {
                String message2 = "" + '[' + this.getCODE_SNIPPET_TAG() + "]: " + "A snippet with id " + snippetId + " was not found for '" + rawMarkdownDirective.getCompleteString() + '\'';
                throw (Throwable)DocuMaidException.Companion.aDocuMaidException(message2, file);
            }
            Path path = snippetsLookupTable.getUniqueSnippet(snippetId);
            FileObjectsFastLookUpTable fileLookupTable = project.getInformation(FileObjectsFastLookUpTable.Companion.getFILES_LOOKUP_TABLE_KEY());
            FileObject fileObject = fileLookupTable.getFileObject(path);
            FileObject fileObject2 = fileObject;
            if (fileObject2 instanceof JavaFile) {
                rawSnippet = ((JavaFile)fileObject).snippetForId(snippetId);
            } else if (fileObject2 instanceof XmlFile) {
                rawSnippet = ((XmlFile)fileObject).snippetForId(snippetId);
            } else if (fileObject2 instanceof UnclassifiedFile) {
                rawSnippet = ((UnclassifiedFile)fileObject).snippetForId(snippetId);
            } else {
                FileObject fileObject3 = fileObject;
                String message3 = "" + '[' + this.getCODE_SNIPPET_TAG() + "]: Could not load snippet " + snippetId + ' ' + "from file " + (fileObject3 != null ? fileObject3.absolutePath() : null) + " for directive '" + rawMarkdownDirective.getCompleteString() + '\'';
                throw (Throwable)DocuMaidException.Companion.aDocuMaidException(message3, file);
            }
            RawSnippet snippet = rawSnippet;
            FileObject fileObject4 = fileObject;
            if (fileObject4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type de.quantummaid.documaid.collecting.structure.ProjectFile");
            }
            CodeSnippet codeSnippet = new CodeSnippet(StringsKt.trimIndent((String)snippet.getContent()), (ProjectFile)fileObject4);
            MarkdownCodeSection markdownCodeSection = MarkdownCodeSection.Companion.createForFile(codeSnippet.getCode(), (ProjectFile)fileObject);
            return CodeSnippetMarkdown.Companion.create(markdownCodeSection);
        }

        private final CodeSnippetMarkdown loadCompleteFile(Path path, MarkdownFile file, RawMarkdownDirective rawMarkdownDirective) {
            Path targetPath = file.absolutePath().getParent().resolve(path);
            if (!Files.exists(targetPath, new LinkOption[0]) || !Files.isRegularFile(targetPath, new LinkOption[0])) {
                String message2 = "Found [" + this.getCODE_SNIPPET_TAG() + "] referencing not existing file '" + path + "' " + "in '" + rawMarkdownDirective.getCompleteString() + '\'';
                throw (Throwable)DocuMaidException.Companion.aDocuMaidException(message2, file);
            }
            Path path2 = targetPath;
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"targetPath");
            String content = FileReaderKt.readFile(path2);
            CodeSnippet codeSnippet = new CodeSnippet(content, UnclassifiedFile.Companion.create(targetPath));
            MarkdownCodeSection markdownCodeSection = MarkdownCodeSection.Companion.createForPath(codeSnippet.getCode(), path);
            return CodeSnippetMarkdown.Companion.create(markdownCodeSection);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

