/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.domain.paths;

import de.quantummaid.documaid.collecting.structure.Directory;
import de.quantummaid.documaid.collecting.structure.ProjectFile;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lde/quantummaid/documaid/domain/paths/IndexedPath;", "", "name", "", "index", "", "(Ljava/lang/String;I)V", "getIndex", "()I", "getName", "()Ljava/lang/String;", "Companion", "documaid"})
public final class IndexedPath {
    @NotNull
    private final String name;
    private final int index;
    private static final Regex INDEXED_FILE_PATTERN;
    public static final Companion Companion;

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final int getIndex() {
        return this.index;
    }

    public IndexedPath(@NotNull String name, int index) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.name = name;
        this.index = index;
    }

    static {
        Companion = new Companion(null);
        INDEXED_FILE_PATTERN = new Regex("(?<index>[\\d]+)_+(?<name>.*)");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\nJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lde/quantummaid/documaid/domain/paths/IndexedPath$Companion;", "", "()V", "INDEXED_FILE_PATTERN", "Lkotlin/text/Regex;", "anIndexedPath", "Lde/quantummaid/documaid/domain/paths/IndexedPath;", "file", "Lde/quantummaid/documaid/collecting/structure/ProjectFile;", "path", "Ljava/nio/file/Path;", "fileName", "", "filePath", "isIndexedPath", "", "directory", "Lde/quantummaid/documaid/collecting/structure/Directory;", "documaid"})
    public static final class Companion {
        @NotNull
        public final IndexedPath anIndexedPath(@NotNull ProjectFile file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            return this.anIndexedPath(file.name(), file.absolutePath());
        }

        @NotNull
        public final IndexedPath anIndexedPath(@NotNull Path path) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            String fileName = ((Object)path.getFileName()).toString();
            return this.anIndexedPath(fileName, path.toAbsolutePath());
        }

        @NotNull
        public final IndexedPath anIndexedPath(@NotNull String fileName, @Nullable Path filePath) {
            Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
            Path path = filePath;
            String parsingErrorMessage = "Cannot extract index from file $" + (path != null ? (Comparable)path : (Comparable)((Object)fileName));
            MatchResult matchResult = INDEXED_FILE_PATTERN.matchEntire((CharSequence)fileName);
            if (matchResult == null) {
                throw (Throwable)new IllegalArgumentException(parsingErrorMessage);
            }
            MatchResult matchEntire = matchResult;
            Object object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchEntire.getGroups(), (String)"index");
            if (object == null || (object = object.getValue()) == null) {
                throw (Throwable)new IllegalArgumentException(parsingErrorMessage);
            }
            Object index = object;
            Object object2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchEntire.getGroups(), (String)"name");
            if (object2 == null || (object2 = object2.getValue()) == null) {
                throw (Throwable)new IllegalArgumentException(parsingErrorMessage);
            }
            Object name = object2;
            int indexInt = Integer.parseInt((String)index);
            return new IndexedPath((String)name, indexInt);
        }

        public final boolean isIndexedPath(@NotNull ProjectFile file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            return this.isIndexedPath(file.name());
        }

        public final boolean isIndexedPath(@NotNull Directory directory) {
            Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
            return this.isIndexedPath(directory.name());
        }

        public final boolean isIndexedPath(@NotNull Path path) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            String fileName = ((Object)path.getFileName()).toString();
            return this.isIndexedPath(fileName);
        }

        public final boolean isIndexedPath(@NotNull String fileName) {
            Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
            MatchResult matchEntire = INDEXED_FILE_PATTERN.matchEntire((CharSequence)fileName);
            return matchEntire != null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

