/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.domain.markdown.tagBased.plugin;

import de.quantummaid.documaid.collecting.structure.Project;
import de.quantummaid.documaid.config.DocuMaidConfiguration;
import de.quantummaid.documaid.config.MavenConfiguration;
import de.quantummaid.documaid.domain.markdown.MarkdownFile;
import de.quantummaid.documaid.domain.markdown.tagBased.OptionsString;
import de.quantummaid.documaid.domain.markdown.tagBased.RawMarkdownDirective;
import de.quantummaid.documaid.domain.markdown.tagBased.plugin.PluginDirective;
import de.quantummaid.documaid.domain.maven.ArtifactId;
import de.quantummaid.documaid.domain.maven.GroupId;
import de.quantummaid.documaid.domain.maven.MavenGoal;
import de.quantummaid.documaid.domain.maven.MavenPhase;
import de.quantummaid.documaid.domain.maven.Version;
import de.quantummaid.documaid.errors.DocuMaidException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lde/quantummaid/documaid/domain/markdown/tagBased/plugin/DependencyDirectiveOptions;", "", "groupId", "Lde/quantummaid/documaid/domain/maven/GroupId;", "artifactId", "Lde/quantummaid/documaid/domain/maven/ArtifactId;", "version", "Lde/quantummaid/documaid/domain/maven/Version;", "goal", "Lde/quantummaid/documaid/domain/maven/MavenGoal;", "phase", "Lde/quantummaid/documaid/domain/maven/MavenPhase;", "(Lde/quantummaid/documaid/domain/maven/GroupId;Lde/quantummaid/documaid/domain/maven/ArtifactId;Lde/quantummaid/documaid/domain/maven/Version;Lde/quantummaid/documaid/domain/maven/MavenGoal;Lde/quantummaid/documaid/domain/maven/MavenPhase;)V", "getArtifactId", "()Lde/quantummaid/documaid/domain/maven/ArtifactId;", "getGoal", "()Lde/quantummaid/documaid/domain/maven/MavenGoal;", "getGroupId", "()Lde/quantummaid/documaid/domain/maven/GroupId;", "getPhase", "()Lde/quantummaid/documaid/domain/maven/MavenPhase;", "getVersion", "()Lde/quantummaid/documaid/domain/maven/Version;", "Companion", "documaid"})
public final class DependencyDirectiveOptions {
    @NotNull
    private final GroupId groupId;
    @NotNull
    private final ArtifactId artifactId;
    @NotNull
    private final Version version;
    @NotNull
    private final MavenGoal goal;
    @NotNull
    private final MavenPhase phase;
    private static final String PLUGIN_OPTIONS_REGEX = "\\(? *(?<groupId>groupId(=[^ ]*)?) *(?<artifactId>artifactId(=[^ ]*)?) *(?<version>version(=[^ ]*)?) *(?<goal>goal=[^ ]*) *(?<phase>phase=[^ ]*) *\\)?";
    private static final Regex PROPERTY_VALUE_REGEX;
    public static final Companion Companion;

    @NotNull
    public final GroupId getGroupId() {
        return this.groupId;
    }

    @NotNull
    public final ArtifactId getArtifactId() {
        return this.artifactId;
    }

    @NotNull
    public final Version getVersion() {
        return this.version;
    }

    @NotNull
    public final MavenGoal getGoal() {
        return this.goal;
    }

    @NotNull
    public final MavenPhase getPhase() {
        return this.phase;
    }

    public DependencyDirectiveOptions(@NotNull GroupId groupId, @NotNull ArtifactId artifactId, @NotNull Version version, @NotNull MavenGoal goal, @NotNull MavenPhase phase) {
        Intrinsics.checkParameterIsNotNull((Object)groupId, (String)"groupId");
        Intrinsics.checkParameterIsNotNull((Object)artifactId, (String)"artifactId");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        Intrinsics.checkParameterIsNotNull((Object)goal, (String)"goal");
        Intrinsics.checkParameterIsNotNull((Object)phase, (String)"phase");
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.goal = goal;
        this.phase = phase;
    }

    static {
        Companion = new Companion(null);
        PLUGIN_OPTIONS_REGEX = PLUGIN_OPTIONS_REGEX;
        String string = "[\\w]+=(?<value>.+)";
        boolean bl = false;
        PROPERTY_VALUE_REGEX = new Regex(string);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0002J\"\u0010\u0019\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lde/quantummaid/documaid/domain/markdown/tagBased/plugin/DependencyDirectiveOptions$Companion;", "", "()V", "PLUGIN_OPTIONS_REGEX", "", "PROPERTY_VALUE_REGEX", "Lkotlin/text/Regex;", "create", "Lde/quantummaid/documaid/domain/markdown/tagBased/plugin/DependencyDirectiveOptions;", "rawMarkdownDirective", "Lde/quantummaid/documaid/domain/markdown/tagBased/RawMarkdownDirective;", "file", "Lde/quantummaid/documaid/domain/markdown/MarkdownFile;", "project", "Lde/quantummaid/documaid/collecting/structure/Project;", "extractArtifactId", "Lde/quantummaid/documaid/domain/maven/ArtifactId;", "matchResult", "Lkotlin/text/MatchResult;", "mavenConfig", "Lde/quantummaid/documaid/config/MavenConfiguration;", "extractGoal", "Lde/quantummaid/documaid/domain/maven/MavenGoal;", "extractGroupId", "Lde/quantummaid/documaid/domain/maven/GroupId;", "extractMandatoryValue", "valueName", "extractPhase", "Lde/quantummaid/documaid/domain/maven/MavenPhase;", "extractVersion", "Lde/quantummaid/documaid/domain/maven/Version;", "documaid"})
    public static final class Companion {
        @NotNull
        public final DependencyDirectiveOptions create(@NotNull RawMarkdownDirective rawMarkdownDirective, @NotNull MarkdownFile file, @NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)rawMarkdownDirective, (String)"rawMarkdownDirective");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            MavenConfiguration mavenConfiguration = project.getInformation(DocuMaidConfiguration.Companion.getDOCUMAID_CONFIGURATION_KEY()).getMavenConfiguration();
            OptionsString optionsString = rawMarkdownDirective.getOptionsString();
            String string = PLUGIN_OPTIONS_REGEX;
            boolean bl = false;
            MatchResult matchEntire = new Regex(string).matchEntire((CharSequence)optionsString.getValue());
            if (matchEntire != null) {
                GroupId groupId = this.extractGroupId(matchEntire, mavenConfiguration, file);
                ArtifactId artifactId = this.extractArtifactId(matchEntire, mavenConfiguration, file);
                Version version = this.extractVersion(matchEntire, mavenConfiguration, file);
                MavenGoal goal = this.extractGoal(matchEntire, file);
                MavenPhase phase = this.extractPhase(matchEntire, file);
                return new DependencyDirectiveOptions(groupId, artifactId, version, goal, phase);
            }
            String message2 = "Cannot parse options for [" + PluginDirective.Companion.getPLUGIN_TAG().getValue() + "]: " + optionsString.getValue();
            throw (Throwable)DocuMaidException.Companion.aDocuMaidException(message2, file);
        }

        private final GroupId extractGroupId(MatchResult matchResult, MavenConfiguration mavenConfig, MarkdownFile file) {
            String groupIdString = this.extractMandatoryValue(matchResult, "groupId", file);
            return groupIdString != null ? GroupId.Companion.create(groupIdString) : mavenConfig.getGroupId();
        }

        private final ArtifactId extractArtifactId(MatchResult matchResult, MavenConfiguration mavenConfig, MarkdownFile file) {
            String artifactIdString = this.extractMandatoryValue(matchResult, "artifactId", file);
            return artifactIdString != null ? ArtifactId.Companion.create(artifactIdString) : mavenConfig.getArtifactId();
        }

        private final Version extractVersion(MatchResult matchResult, MavenConfiguration mavenConfig, MarkdownFile file) {
            String versionString = this.extractMandatoryValue(matchResult, "version", file);
            return versionString != null ? Version.Companion.create(versionString) : mavenConfig.getVersion();
        }

        private final MavenGoal extractGoal(MatchResult matchResult, MarkdownFile file) {
            String goalString = this.extractMandatoryValue(matchResult, "goal", file);
            if (goalString == null) {
                String message2 = '[' + PluginDirective.Companion.getPLUGIN_TAG().getValue() + "] requires 'goal' to be defined with a value in options.";
                throw (Throwable)DocuMaidException.Companion.aDocuMaidException(message2, file);
            }
            return MavenGoal.Companion.create(goalString);
        }

        private final MavenPhase extractPhase(MatchResult matchResult, MarkdownFile file) {
            String phaseString = this.extractMandatoryValue(matchResult, "phase", file);
            if (phaseString == null) {
                String message2 = '[' + PluginDirective.Companion.getPLUGIN_TAG().getValue() + "] requires 'phase' to be defined with a value in options.";
                throw (Throwable)DocuMaidException.Companion.aDocuMaidException(message2, file);
            }
            return MavenPhase.Companion.create(phaseString);
        }

        private final String extractMandatoryValue(MatchResult matchResult, String valueName, MarkdownFile file) {
            MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)valueName);
            if (matchGroup != null) {
                String string;
                MatchResult propertyValueMatch = PROPERTY_VALUE_REGEX.matchEntire((CharSequence)matchGroup.getValue());
                if (propertyValueMatch != null) {
                    MatchGroup matchGroup2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)propertyValueMatch.getGroups(), (String)"value");
                    if (matchGroup2 == null) {
                        Intrinsics.throwNpe();
                    }
                    string = matchGroup2.getValue();
                } else {
                    string = null;
                }
                return string;
            }
            throw (Throwable)DocuMaidException.Companion.aDocuMaidException('[' + PluginDirective.Companion.getPLUGIN_TAG().getValue() + "] requires '" + valueName + "' to be set in options.", file);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

