/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.processing;

import de.quantummaid.documaid.collecting.structure.Directory;
import de.quantummaid.documaid.collecting.structure.Project;
import de.quantummaid.documaid.config.Goal;
import de.quantummaid.documaid.domain.markdown.MarkdownFile;
import de.quantummaid.documaid.domain.paths.IndexedPath;
import de.quantummaid.documaid.domain.paths.PathUtilsKt;
import de.quantummaid.documaid.processing.HugoIndexedDirectoryMarkdownFile;
import de.quantummaid.documaid.processing.ProcessingResult;
import de.quantummaid.documaid.processing.ProcessingVisitorAdapter;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a8\u0006\u000e"}, d2={"Lde/quantummaid/documaid/processing/HugoProcessingGenerationVisitor;", "Lde/quantummaid/documaid/processing/ProcessingVisitorAdapter;", "()V", "afterDirectoryProcessing", "", "directory", "Lde/quantummaid/documaid/collecting/structure/Directory;", "project", "Lde/quantummaid/documaid/collecting/structure/Project;", "goal", "Lde/quantummaid/documaid/config/Goal;", "directoryProcessingResults", "", "Lde/quantummaid/documaid/processing/ProcessingResult;", "documaid"})
public final class HugoProcessingGenerationVisitor
extends ProcessingVisitorAdapter {
    @Override
    public void afterDirectoryProcessing(@NotNull Directory directory, @NotNull Project project, @NotNull Goal goal, @NotNull List<ProcessingResult> directoryProcessingResults) {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)goal), (String)"goal");
        Intrinsics.checkParameterIsNotNull(directoryProcessingResults, (String)"directoryProcessingResults");
        Path projectRelativePath = PathUtilsKt.makeRelativeTo(directory, project);
        if (PathUtilsKt.pathUnderTopLevelDirectory(projectRelativePath, "documentation/") && IndexedPath.Companion.isIndexedPath(projectRelativePath)) {
            Path fileName;
            IndexedPath indexedPath = IndexedPath.Companion.anIndexedPath(projectRelativePath);
            Path path = fileName = directory.absolutePath().resolve("_index.md");
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"fileName");
            MarkdownFile markdownFile = HugoIndexedDirectoryMarkdownFile.Companion.create(path, indexedPath);
            directory.addChild(markdownFile);
            ProcessingResult processingResult = ProcessingResult.Companion.successfulProcessingResult(markdownFile, markdownFile.content());
            directoryProcessingResults.add(processingResult);
        }
    }
}

