/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.mojos;

import de.quantummaid.documaid.DocuMaid;
import de.quantummaid.documaid.config.DocuMaidConfiguration;
import de.quantummaid.documaid.config.DocuMaidConfigurationBuilder;
import de.quantummaid.documaid.config.Goal;
import de.quantummaid.documaid.config.MavenConfiguration;
import de.quantummaid.documaid.config.Platform;
import de.quantummaid.documaid.domain.maven.ArtifactId;
import de.quantummaid.documaid.domain.maven.GroupId;
import de.quantummaid.documaid.domain.maven.Version;
import de.quantummaid.documaid.errors.DokuMaidError;
import de.quantummaid.documaid.errors.ErrorsEncounteredInDokuMaidException;
import de.quantummaid.documaid.logging.MavenLogger;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0013H\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0011H\u0002R\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u00020\u00048\u0002X\u0083D\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u0004\u0018\u00010\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000f8\u0002X\u0083D\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00118\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lde/quantummaid/documaid/mojos/DocuMaidMojo;", "Lorg/apache/maven/plugin/AbstractMojo;", "()V", "generationFlavor", "", "goal", "Lde/quantummaid/documaid/config/Goal;", "getGoal", "()Lde/quantummaid/documaid/config/Goal;", "hugoOutputPath", "platform", "project", "Lorg/apache/maven/project/MavenProject;", "repositoryUrl", "skip", "", "skipPaths", "", "applyOptionalHugoConfiguration", "", "configurationBuilder", "Lde/quantummaid/documaid/config/DocuMaidConfigurationBuilder;", "createMavenConfiguration", "Lde/quantummaid/documaid/config/MavenConfiguration;", "determinePlatform", "Lde/quantummaid/documaid/config/Platform;", "execute", "getSkippedPaths", "Ljava/nio/file/Path;", "documaid"})
public abstract class DocuMaidMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    private final MavenProject project;
    @Parameter(property="skipTests", defaultValue="false")
    private final boolean skip = false;
    @Parameter(property="skipPaths")
    private final List<String> skipPaths;
    @Parameter(property="platform")
    private final String platform;
    @Parameter(property="hugoOutputPath")
    private final String hugoOutputPath = "hugo";
    @Parameter(property="repositoryUrl")
    private final String repositoryUrl;
    @Parameter(property="generationFlavor")
    private final String generationFlavor;

    @NotNull
    protected abstract Goal getGoal();

    public void execute() throws MojoFailureException {
        if (this.skip) {
            return;
        }
        MavenProject mavenProject = this.project;
        if (mavenProject == null) {
            Intrinsics.throwNpe();
        }
        File file = mavenProject.getBasedir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project!!.basedir");
        String basePath = file.getPath();
        Log log = this.getLog();
        DocuMaidConfigurationBuilder docuMaidConfigurationBuilder = DocuMaidConfiguration.Companion.aDocuMaidConfiguration();
        String string = basePath;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"basePath");
        DocuMaidConfigurationBuilder docuMaidConfigurationBuilder2 = docuMaidConfigurationBuilder.withBasePath(string).forGoal(this.getGoal());
        Log log2 = log;
        Intrinsics.checkExpressionValueIsNotNull((Object)log2, (String)"log");
        DocuMaidConfigurationBuilder configurationBuilder = docuMaidConfigurationBuilder2.withLogger(MavenLogger.Companion.mavenLogger(log2)).withMavenConfiguration(this.createMavenConfiguration()).withSkippedPaths(this.getSkippedPaths()).forPlatform(this.determinePlatform()).withGenerationFlavorType(this.generationFlavor);
        this.applyOptionalHugoConfiguration(configurationBuilder);
        DocuMaidConfiguration configuration = configurationBuilder.build();
        DocuMaid dokuMaid = DocuMaid.Companion.docuMaid(configuration);
        try {
            log.info((CharSequence)"DocuMaid started");
            dokuMaid.pimpMyDocu();
            log.info((CharSequence)"DocuMaid finished successful");
        }
        catch (ErrorsEncounteredInDokuMaidException e) {
            List<DokuMaidError> errors = e.getErrors();
            log.error((CharSequence)("DocuMaid finished with " + errors.size() + " errors."));
            Iterable $this$forEach$iv = errors;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DokuMaidError error = (DokuMaidError)element$iv;
                boolean bl = false;
                log.error((CharSequence)error.message());
            }
            throw (Throwable)new MojoFailureException("DocuMaid encountered errors during execution. See log for more information.");
        }
    }

    private final MavenConfiguration createMavenConfiguration() {
        MavenConfiguration mavenConfiguration;
        if (this.project != null) {
            String string = this.project.getGroupId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.groupId");
            GroupId groupId = GroupId.Companion.create(string);
            String string2 = this.project.getArtifactId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"project.artifactId");
            ArtifactId artifactId = ArtifactId.Companion.create(string2);
            String string3 = this.project.getVersion();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"project.version");
            Version version = Version.Companion.create(string3);
            mavenConfiguration = new MavenConfiguration(groupId, artifactId, version);
        } else {
            mavenConfiguration = new MavenConfiguration(null, null, null);
        }
        return mavenConfiguration;
    }

    private final List<Path> getSkippedPaths() {
        if (this.skipPaths != null && !this.skipPaths.isEmpty()) {
            Path path;
            Path it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.skipPaths;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                path = Paths.get((String)((Object)it), new String[0]);
                collection.add(path);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Path)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                path = it.toAbsolutePath();
                collection.add(path);
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.emptyList();
    }

    private final Platform determinePlatform() {
        Platform platform;
        if (this.platform == null) {
            return Platform.GITHUB;
        }
        String string = this.platform;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        string = string3;
        switch (string.hashCode()) {
            case 3214005: {
                if (string.equals("hugo")) {
                    platform = Platform.HUGO;
                    break;
                }
            }
            default: {
                platform = Platform.GITHUB;
            }
        }
        return platform;
    }

    private final void applyOptionalHugoConfiguration(DocuMaidConfigurationBuilder configurationBuilder) {
        Platform resolvedPlatform = this.determinePlatform();
        if (resolvedPlatform == Platform.HUGO) {
            configurationBuilder.withHugoOutputPath(this.hugoOutputPath);
            if (this.repositoryUrl != null) {
                configurationBuilder.withRepositoryUrl(this.repositoryUrl);
            }
        }
    }
}

