/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.generating;

import de.quantummaid.documaid.collecting.structure.FileType;
import de.quantummaid.documaid.config.DocuMaidConfiguration;
import de.quantummaid.documaid.errors.VerificationError;
import de.quantummaid.documaid.generating.FileGenerator;
import de.quantummaid.documaid.generating.GenerationFlavor;
import de.quantummaid.documaid.processing.ProcessingResult;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0016"}, d2={"Lde/quantummaid/documaid/generating/HugoFileGenerator;", "Lde/quantummaid/documaid/generating/FileGenerator;", "basePath", "Ljava/nio/file/Path;", "hugoBasePath", "generationFlavor", "Lde/quantummaid/documaid/generating/GenerationFlavor;", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Lde/quantummaid/documaid/generating/GenerationFlavor;)V", "getBasePath", "()Ljava/nio/file/Path;", "getGenerationFlavor", "()Lde/quantummaid/documaid/generating/GenerationFlavor;", "getHugoBasePath", "createDirectoryAndParentsIfNotExisting", "", "path", "generate", "", "Lde/quantummaid/documaid/errors/VerificationError;", "processingResults", "Lde/quantummaid/documaid/processing/ProcessingResult;", "Companion", "documaid"})
public final class HugoFileGenerator
implements FileGenerator {
    @NotNull
    private final Path basePath;
    @NotNull
    private final Path hugoBasePath;
    @NotNull
    private final GenerationFlavor generationFlavor;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public List<VerificationError> generate(@NotNull List<ProcessingResult> processingResults) {
        List list;
        Intrinsics.checkParameterIsNotNull(processingResults, (String)"processingResults");
        try {
            Iterable $this$mapNotNullTo$iv$iv;
            Object it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = processingResults;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (ProcessingResult)element$iv$iv;
                boolean bl = false;
                if (!(((ProcessingResult)it).getFile().fileType() == FileType.MARKDOWN)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            it = $this$forEach$iv$iv$iv.iterator();
            while (it.hasNext()) {
                ProcessingResult processingResult;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = it.next();
                boolean bl = false;
                ProcessingResult it2 = (ProcessingResult)element$iv$iv;
                boolean bl2 = false;
                if (this.generationFlavor.process(it2) == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                ProcessingResult it$iv$iv = processingResult;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$mapNotNullTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (ProcessingResult)element$iv$iv;
                boolean bl = false;
                if (!((ProcessingResult)it).getContentChanged()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                Path targetPath;
                ProcessingResult it3 = (ProcessingResult)element$iv;
                boolean bl = false;
                Path absoluteFilePath = it3.getFile().absolutePath();
                Path relativizedPath = this.basePath.relativize(absoluteFilePath);
                Path path = targetPath = this.hugoBasePath.resolve(relativizedPath);
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"targetPath");
                Path path2 = path.getParent();
                Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"targetPath.parent");
                this.createDirectoryAndParentsIfNotExisting(path2);
                File file = targetPath.toFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"targetPath.toFile()");
                FilesKt.writeText$default((File)file, (String)it3.getNewContent(), null, (int)2, null);
            }
            list = CollectionsKt.emptyList();
        }
        catch (Exception e) {
            list = CollectionsKt.listOf((Object)VerificationError.Companion.createFromException(e, null));
        }
        return list;
    }

    private final void createDirectoryAndParentsIfNotExisting(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
    }

    @NotNull
    public final Path getBasePath() {
        return this.basePath;
    }

    @NotNull
    public final Path getHugoBasePath() {
        return this.hugoBasePath;
    }

    @NotNull
    public final GenerationFlavor getGenerationFlavor() {
        return this.generationFlavor;
    }

    public HugoFileGenerator(@NotNull Path basePath, @NotNull Path hugoBasePath, @NotNull GenerationFlavor generationFlavor) {
        Intrinsics.checkParameterIsNotNull((Object)basePath, (String)"basePath");
        Intrinsics.checkParameterIsNotNull((Object)hugoBasePath, (String)"hugoBasePath");
        Intrinsics.checkParameterIsNotNull((Object)generationFlavor, (String)"generationFlavor");
        this.basePath = basePath;
        this.hugoBasePath = hugoBasePath;
        this.generationFlavor = generationFlavor;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lde/quantummaid/documaid/generating/HugoFileGenerator$Companion;", "", "()V", "create", "Lde/quantummaid/documaid/generating/HugoFileGenerator;", "docuMaidConfiguration", "Lde/quantummaid/documaid/config/DocuMaidConfiguration;", "documaid"})
    public static final class Companion {
        @NotNull
        public final HugoFileGenerator create(@NotNull DocuMaidConfiguration docuMaidConfiguration) {
            Intrinsics.checkParameterIsNotNull((Object)docuMaidConfiguration, (String)"docuMaidConfiguration");
            Path basePath = docuMaidConfiguration.getBasePath();
            Path hugoBasePath = basePath.resolve(docuMaidConfiguration.getHugoOutputPath());
            GenerationFlavor generationFlavor = GenerationFlavor.Companion.createFor(docuMaidConfiguration);
            Path path = hugoBasePath;
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"hugoBasePath");
            return new HugoFileGenerator(basePath, path, generationFlavor);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

