/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.domain.markdown.tagBased.tableOfContents;

import de.quantummaid.documaid.domain.markdown.MarkdownFile;
import de.quantummaid.documaid.domain.markdown.tagBased.OptionsString;
import de.quantummaid.documaid.domain.markdown.tagBased.tableOfContents.TableOfContentsDirective;
import de.quantummaid.documaid.errors.DocuMaidException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lde/quantummaid/documaid/domain/markdown/tagBased/tableOfContents/TableOfContentsDirectiveOptions;", "", "tocScanBaseDirectory", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "getTocScanBaseDirectory", "()Ljava/nio/file/Path;", "Companion", "documaid"})
public final class TableOfContentsDirectiveOptions {
    @NotNull
    private final Path tocScanBaseDirectory;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Path getTocScanBaseDirectory() {
        return this.tocScanBaseDirectory;
    }

    public TableOfContentsDirectiveOptions(@NotNull Path tocScanBaseDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)tocScanBaseDirectory, (String)"tocScanBaseDirectory");
        this.tocScanBaseDirectory = tocScanBaseDirectory;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lde/quantummaid/documaid/domain/markdown/tagBased/tableOfContents/TableOfContentsDirectiveOptions$Companion;", "", "()V", "create", "Lde/quantummaid/documaid/domain/markdown/tagBased/tableOfContents/TableOfContentsDirectiveOptions;", "optionsString", "Lde/quantummaid/documaid/domain/markdown/tagBased/OptionsString;", "directoryBasePath", "Ljava/nio/file/Path;", "file", "Lde/quantummaid/documaid/domain/markdown/MarkdownFile;", "documaid"})
    public static final class Companion {
        @NotNull
        public final TableOfContentsDirectiveOptions create(@NotNull OptionsString optionsString, @NotNull Path directoryBasePath, @NotNull MarkdownFile file) {
            Intrinsics.checkParameterIsNotNull((Object)optionsString, (String)"optionsString");
            Intrinsics.checkParameterIsNotNull((Object)directoryBasePath, (String)"directoryBasePath");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            String string = " *\\(? *(?<baseDir>[^ )]+) *\\)? *";
            boolean bl = false;
            Regex optionsRegex = new Regex(string);
            MatchResult matchResult = optionsRegex.matchEntire((CharSequence)optionsString.getValue());
            if (matchResult != null) {
                String baseDirectoryPathString;
                Path tocScanBaseDirectory;
                MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)"baseDir");
                if (matchGroup == null) {
                    Intrinsics.throwNpe();
                }
                if (!Files.exists(tocScanBaseDirectory = directoryBasePath.resolve(baseDirectoryPathString = matchGroup.getValue()).normalize(), new LinkOption[0])) {
                    String message2 = "" + '[' + TableOfContentsDirective.Companion.getTOC_TAG() + "] Cannot create TOC for not existing directory '" + baseDirectoryPathString + '\'';
                    throw (Throwable)DocuMaidException.Companion.aDocuMaidException(message2, file);
                }
                Path path = tocScanBaseDirectory;
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"tocScanBaseDirectory");
                return new TableOfContentsDirectiveOptions(path);
            }
            throw (Throwable)DocuMaidException.Companion.aDocuMaidException("" + '[' + TableOfContentsDirective.Companion.getTOC_TAG() + "] Could not match TOC options '" + optionsString.getValue() + '\'', file);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

