/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.domain.markdown.tagBased.tableOfContents;

import de.quantummaid.documaid.collecting.structure.Project;
import de.quantummaid.documaid.domain.markdown.MarkdownFile;
import de.quantummaid.documaid.domain.markdown.tagBased.MarkdownReplacement;
import de.quantummaid.documaid.domain.markdown.tagBased.MarkdownTagHandler;
import de.quantummaid.documaid.domain.markdown.tagBased.RawMarkdownDirective;
import de.quantummaid.documaid.domain.markdown.tagBased.matching.TrailingMarkdownMatchResult;
import de.quantummaid.documaid.domain.markdown.tagBased.tableOfContents.GithubTableOfContentsMarkdown;
import de.quantummaid.documaid.domain.markdown.tagBased.tableOfContents.TableOfContentsDirective;
import de.quantummaid.documaid.domain.tableOfContents.TableOfContents;
import de.quantummaid.documaid.errors.DocuMaidException;
import de.quantummaid.documaid.errors.VerificationError;
import de.quantummaid.documaid.preparing.tableOfContents.TableOfContentsLookupData;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00110\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0012\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J&\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0015"}, d2={"Lde/quantummaid/documaid/domain/markdown/tagBased/tableOfContents/GithubTableOfContentsMarkdownTagHandler;", "Lde/quantummaid/documaid/domain/markdown/tagBased/MarkdownTagHandler;", "()V", "generate", "Lkotlin/Pair;", "Lde/quantummaid/documaid/domain/markdown/tagBased/MarkdownReplacement;", "", "Lde/quantummaid/documaid/errors/VerificationError;", "directive", "Lde/quantummaid/documaid/domain/markdown/tagBased/RawMarkdownDirective;", "file", "Lde/quantummaid/documaid/domain/markdown/MarkdownFile;", "project", "Lde/quantummaid/documaid/collecting/structure/Project;", "tag", "", "textToBeReplaced", "Lde/quantummaid/documaid/domain/markdown/tagBased/matching/TrailingMarkdownMatchResult;", "textToReplace", "validate", "Companion", "documaid"})
public final class GithubTableOfContentsMarkdownTagHandler
implements MarkdownTagHandler {
    @NotNull
    private static final Regex INDEX_MARKDOWN_FILE_NAME_PATTERN;
    public static final Companion Companion;

    @Override
    @NotNull
    public String tag() {
        return TableOfContentsDirective.Companion.getTOC_TAG().toString();
    }

    @Override
    @NotNull
    public Pair<MarkdownReplacement, List<VerificationError>> generate(@NotNull RawMarkdownDirective directive, @NotNull MarkdownFile file, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)directive, (String)"directive");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String textToReplace = this.textToReplace(project, directive, file);
        Pair<String, TrailingMarkdownMatchResult> pair = this.textToBeReplaced(directive);
        String textToBeReplaced = (String)pair.component1();
        int rangeStart = directive.getRange().getFirst();
        int rangeEnd = rangeStart + Math.max(textToBeReplaced.length(), textToReplace.length());
        MarkdownReplacement markdownReplacement = new MarkdownReplacement(new IntRange(rangeStart, rangeEnd), textToBeReplaced, textToReplace);
        return new Pair((Object)markdownReplacement, (Object)CollectionsKt.emptyList());
    }

    private final String textToReplace(Project project, RawMarkdownDirective directive, MarkdownFile file) {
        TableOfContentsLookupData tableOfContentsLookupData = project.getInformation(TableOfContentsLookupData.Companion.getTOC_LOOKUP_KEY());
        if (!tableOfContentsLookupData.tableOfContentsAvailable()) {
            throw (Throwable)DocuMaidException.Companion.aDocuMaidException("Found [" + this.tag() + "] without a Table of Contents being generated", file);
        }
        TableOfContents tableOfContents = tableOfContentsLookupData.getTableOfContents();
        GithubTableOfContentsMarkdown tocMarkdown = new GithubTableOfContentsMarkdown(directive, tableOfContents, file);
        return tocMarkdown.markdownString();
    }

    private final Pair<String, TrailingMarkdownMatchResult> textToBeReplaced(RawMarkdownDirective directive) {
        TrailingMarkdownMatchResult markdownMatchResult = GithubTableOfContentsMarkdown.Companion.startsWithTrailingTableOfContentsMarkdown(directive.getRemainingMarkupFileContent());
        String text = markdownMatchResult.getMatches() ? directive.getCompleteString() + markdownMatchResult.getContent() : directive.getCompleteString();
        return new Pair((Object)text, (Object)markdownMatchResult);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<VerificationError> validate(@NotNull RawMarkdownDirective directive, @NotNull MarkdownFile file, @NotNull Project project) {
        List list;
        void textToBeReplaced;
        Intrinsics.checkParameterIsNotNull((Object)directive, (String)"directive");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String textToReplace = this.textToReplace(project, directive, file);
        Pair<String, TrailingMarkdownMatchResult> pair = this.textToBeReplaced(directive);
        String string = (String)pair.component1();
        TrailingMarkdownMatchResult trailingMarkdownMatchResult = (TrailingMarkdownMatchResult)pair.component2();
        if (Intrinsics.areEqual((Object)textToBeReplaced, (Object)textToReplace) ^ true) {
            boolean trailingCodeFound = trailingMarkdownMatchResult.getMatches();
            if (trailingCodeFound) {
                String message2 = "Found [" + this.tag() + "] tag with incorrect TOC";
                VerificationError verificationError = VerificationError.Companion.create(message2, file);
                list = CollectionsKt.listOf((Object)verificationError);
            } else {
                String message3 = "Found [" + this.tag() + "] tag with missing TOC";
                VerificationError verificationError = VerificationError.Companion.create(message3, file);
                list = CollectionsKt.listOf((Object)verificationError);
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    static {
        Companion = new Companion(null);
        String string = "(?<index>([1-9]|[\\d]{2,}))_+(?<name>[\\w]+)(\\.md)?";
        boolean bl = false;
        INDEX_MARKDOWN_FILE_NAME_PATTERN = new Regex(string);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lde/quantummaid/documaid/domain/markdown/tagBased/tableOfContents/GithubTableOfContentsMarkdownTagHandler$Companion;", "", "()V", "INDEX_MARKDOWN_FILE_NAME_PATTERN", "Lkotlin/text/Regex;", "getINDEX_MARKDOWN_FILE_NAME_PATTERN", "()Lkotlin/text/Regex;", "documaid"})
    public static final class Companion {
        @NotNull
        public final Regex getINDEX_MARKDOWN_FILE_NAME_PATTERN() {
            return INDEX_MARKDOWN_FILE_NAME_PATTERN;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

