/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.domain.markdown.tagBased.link;

import de.quantummaid.documaid.config.Repository;
import de.quantummaid.documaid.domain.markdown.tagBased.link.LinkDirective;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0011\u001a\u00020\u0003R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u0013"}, d2={"Lde/quantummaid/documaid/domain/markdown/tagBased/link/HugoLinkMarkdown;", "", "name", "", "target", "linkDirective", "Lde/quantummaid/documaid/domain/markdown/tagBased/link/LinkDirective;", "repository", "Lde/quantummaid/documaid/config/Repository;", "(Ljava/lang/String;Ljava/lang/String;Lde/quantummaid/documaid/domain/markdown/tagBased/link/LinkDirective;Lde/quantummaid/documaid/config/Repository;)V", "getLinkDirective", "()Lde/quantummaid/documaid/domain/markdown/tagBased/link/LinkDirective;", "getName", "()Ljava/lang/String;", "getRepository", "()Lde/quantummaid/documaid/config/Repository;", "getTarget", "generateMarkdown", "Companion", "documaid"})
public final class HugoLinkMarkdown {
    @NotNull
    private final String name;
    @NotNull
    private final String target;
    @NotNull
    private final LinkDirective linkDirective;
    @NotNull
    private final Repository repository;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String generateMarkdown() {
        String githubUrl = this.repository.urlToFile(this.target);
        String markdownLink = '[' + this.name + "](" + githubUrl + ')';
        return this.linkDirective.getDirective().getCompleteString() + '\n' + markdownLink;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getTarget() {
        return this.target;
    }

    @NotNull
    public final LinkDirective getLinkDirective() {
        return this.linkDirective;
    }

    @NotNull
    public final Repository getRepository() {
        return this.repository;
    }

    public HugoLinkMarkdown(@NotNull String name, @NotNull String target, @NotNull LinkDirective linkDirective, @NotNull Repository repository) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)linkDirective, (String)"linkDirective");
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        this.name = name;
        this.target = target;
        this.linkDirective = linkDirective;
        this.repository = repository;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lde/quantummaid/documaid/domain/markdown/tagBased/link/HugoLinkMarkdown$Companion;", "", "()V", "create", "Lde/quantummaid/documaid/domain/markdown/tagBased/link/HugoLinkMarkdown;", "linkDirective", "Lde/quantummaid/documaid/domain/markdown/tagBased/link/LinkDirective;", "repository", "Lde/quantummaid/documaid/config/Repository;", "documaid"})
    public static final class Companion {
        @NotNull
        public final HugoLinkMarkdown create(@NotNull LinkDirective linkDirective, @NotNull Repository repository) {
            Intrinsics.checkParameterIsNotNull((Object)linkDirective, (String)"linkDirective");
            Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
            String name = linkDirective.getOptions().getName();
            String originalPathString = linkDirective.getOptions().getOriginalPathString();
            return new HugoLinkMarkdown(name, originalPathString, linkDirective, repository);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

