/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.domain.markdown.syntaxBased.hugo.heading;

import de.quantummaid.documaid.config.DocuMaidConfiguration;
import de.quantummaid.documaid.domain.markdown.MarkdownFile;
import de.quantummaid.documaid.domain.paths.IndexedPath;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lde/quantummaid/documaid/domain/markdown/syntaxBased/hugo/heading/HugoHeadingMarkdown;", "", "title", "", "index", "", "(Ljava/lang/String;I)V", "generateMarkdown", "Companion", "documaid"})
public final class HugoHeadingMarkdown {
    private final String title;
    private final int index;
    private static final Regex RAW_HEADING_PATTERN;
    private static final int DEFAULT_INDEX = 1;
    public static final Companion Companion;

    @NotNull
    public final String generateMarkdown() {
        int weight = this.index * 10;
        return StringsKt.trimIndent((String)("\n            ---\n            title: \"" + this.title + "\"\n            weight: " + weight + "\n            ---\n            ")) + "\n";
    }

    private HugoHeadingMarkdown(String title, int index) {
        this.title = title;
        this.index = index;
    }

    static {
        Companion = new Companion(null);
        RAW_HEADING_PATTERN = new Regex("# ?(?<title>[^\n]+)\n");
    }

    public /* synthetic */ HugoHeadingMarkdown(String title, int index, DefaultConstructorMarker $constructor_marker) {
        this(title, index);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0004J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lde/quantummaid/documaid/domain/markdown/syntaxBased/hugo/heading/HugoHeadingMarkdown$Companion;", "", "()V", "DEFAULT_INDEX", "", "RAW_HEADING_PATTERN", "Lkotlin/text/Regex;", "create", "Lde/quantummaid/documaid/domain/markdown/syntaxBased/hugo/heading/HugoHeadingMarkdown;", "rawHeadingString", "", "file", "Lde/quantummaid/documaid/domain/markdown/MarkdownFile;", "docuMaidConfiguration", "Lde/quantummaid/documaid/config/DocuMaidConfiguration;", "title", "index", "extractIndex", "documaid"})
    public static final class Companion {
        @NotNull
        public final HugoHeadingMarkdown create(@NotNull String rawHeadingString, @NotNull MarkdownFile file, @NotNull DocuMaidConfiguration docuMaidConfiguration) {
            Intrinsics.checkParameterIsNotNull((Object)rawHeadingString, (String)"rawHeadingString");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)docuMaidConfiguration, (String)"docuMaidConfiguration");
            MatchResult matchEntire = RAW_HEADING_PATTERN.matchEntire((CharSequence)rawHeadingString);
            String errorMessage = "Could not parse title of heading: '" + rawHeadingString + '\'';
            if (matchEntire == null) {
                throw (Throwable)new IllegalArgumentException(errorMessage);
            }
            Object object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchEntire.getGroups(), (String)"title");
            if (object == null || (object = object.getValue()) == null) {
                throw (Throwable)new IllegalArgumentException(errorMessage);
            }
            Object title = object;
            int indexedFile = this.extractIndex(file, docuMaidConfiguration);
            return new HugoHeadingMarkdown((String)title, indexedFile, null);
        }

        @NotNull
        public final HugoHeadingMarkdown create(@NotNull String title, int index) {
            Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
            return new HugoHeadingMarkdown(title, index, null);
        }

        private final int extractIndex(MarkdownFile file, DocuMaidConfiguration docuMaidConfiguration) {
            if (IndexedPath.Companion.isIndexedPath(file)) {
                IndexedPath indexedFile = IndexedPath.Companion.anIndexedPath(file);
                return indexedFile.getIndex();
            }
            boolean isRootReadme = Intrinsics.areEqual((Object)((Object)docuMaidConfiguration.getBasePath().relativize(file.getPath())).toString(), (Object)"README.md");
            if (isRootReadme) {
                String hugoOutputPath = docuMaidConfiguration.getHugoOutputPath();
                if (IndexedPath.Companion.isIndexedPath(hugoOutputPath)) {
                    return IndexedPath.Companion.anIndexedPath(hugoOutputPath, null).getIndex();
                }
                return 1;
            }
            return 1;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

