/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.domain.tableOfContents;

import de.quantummaid.documaid.collecting.structure.ProjectFile;
import de.quantummaid.documaid.domain.tableOfContents.TableOfContentsDataStructuresKt;
import de.quantummaid.documaid.domain.tableOfContents.TocDataFileObject;
import de.quantummaid.documaid.errors.VerificationError;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\f"}, d2={"Lde/quantummaid/documaid/domain/tableOfContents/TocDataFile;", "Lde/quantummaid/documaid/domain/tableOfContents/TocDataFileObject;", "index", "", "title", "", "scanRootRelativeDirectory", "Ljava/nio/file/Path;", "file", "Lde/quantummaid/documaid/collecting/structure/ProjectFile;", "(ILjava/lang/String;Ljava/nio/file/Path;Lde/quantummaid/documaid/collecting/structure/ProjectFile;)V", "Companion", "documaid"})
public final class TocDataFile
extends TocDataFileObject {
    public static final Companion Companion = new Companion(null);

    public TocDataFile(int index, @NotNull String title, @NotNull Path scanRootRelativeDirectory, @NotNull ProjectFile file) {
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull((Object)scanRootRelativeDirectory, (String)"scanRootRelativeDirectory");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        super(index, title, scanRootRelativeDirectory, file);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lde/quantummaid/documaid/domain/tableOfContents/TocDataFile$Companion;", "", "()V", "create", "Lkotlin/Pair;", "Lde/quantummaid/documaid/domain/tableOfContents/TocDataFile;", "", "Lde/quantummaid/documaid/errors/VerificationError;", "file", "Lde/quantummaid/documaid/collecting/structure/ProjectFile;", "scanBaseDir", "Ljava/nio/file/Path;", "documaid"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Pair<TocDataFile, List<VerificationError>> create(@NotNull ProjectFile file, @NotNull Path scanBaseDir) {
            Pair pair;
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)scanBaseDir, (String)"scanBaseDir");
            try {
                void index;
                Path relativePath;
                Path fileAbsolutePath = file.absolutePath();
                String fileName = ((Object)fileAbsolutePath.getFileName()).toString();
                Pair pair2 = TableOfContentsDataStructuresKt.access$parseName(fileName, fileAbsolutePath);
                int n = ((Number)pair2.component1()).intValue();
                String title = (String)pair2.component2();
                Path path = relativePath = scanBaseDir.relativize(fileAbsolutePath);
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"relativePath");
                TocDataFile tocDataFile = new TocDataFile((int)index, title, path, file);
                pair = new Pair((Object)tocDataFile, (Object)CollectionsKt.emptyList());
            }
            catch (Exception e) {
                VerificationError verificationError = VerificationError.Companion.createFromException(e, file);
                pair = new Pair(null, (Object)CollectionsKt.listOf((Object)verificationError));
            }
            return pair;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

