/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.domain.markdown.navigation;

import de.quantummaid.documaid.collecting.structure.Project;
import de.quantummaid.documaid.domain.markdown.DirectiveTag;
import de.quantummaid.documaid.domain.markdown.MarkdownFile;
import de.quantummaid.documaid.domain.markdown.RawMarkdownDirective;
import de.quantummaid.documaid.domain.navigation.NavigationMarkdown;
import de.quantummaid.documaid.domain.tableOfContents.TableOfContents;
import de.quantummaid.documaid.preparing.tableOfContents.TableOfContentsLookupData;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B3\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u0014"}, d2={"Lde/quantummaid/documaid/domain/markdown/navigation/NavigationDirective;", "", "directive", "Lde/quantummaid/documaid/domain/markdown/RawMarkdownDirective;", "file", "Lde/quantummaid/documaid/domain/markdown/MarkdownFile;", "previousFile", "overviewFile", "nextFile", "(Lde/quantummaid/documaid/domain/markdown/RawMarkdownDirective;Lde/quantummaid/documaid/domain/markdown/MarkdownFile;Lde/quantummaid/documaid/domain/markdown/MarkdownFile;Lde/quantummaid/documaid/domain/markdown/MarkdownFile;Lde/quantummaid/documaid/domain/markdown/MarkdownFile;)V", "getDirective", "()Lde/quantummaid/documaid/domain/markdown/RawMarkdownDirective;", "getFile", "()Lde/quantummaid/documaid/domain/markdown/MarkdownFile;", "getNextFile", "getOverviewFile", "getPreviousFile", "generateMarkdown", "", "Companion", "documaid"})
public final class NavigationDirective {
    @NotNull
    private final RawMarkdownDirective directive;
    @NotNull
    private final MarkdownFile file;
    @Nullable
    private final MarkdownFile previousFile;
    @NotNull
    private final MarkdownFile overviewFile;
    @Nullable
    private final MarkdownFile nextFile;
    @NotNull
    private static final DirectiveTag NAV_TAG;
    public static final Companion Companion;

    @NotNull
    public final String generateMarkdown() {
        NavigationMarkdown navigationMarkdown = new NavigationMarkdown(this.file, this.previousFile, this.overviewFile, this.nextFile);
        return this.directive.getCompleteString() + '\n' + navigationMarkdown.generateMarkdown();
    }

    @NotNull
    public final RawMarkdownDirective getDirective() {
        return this.directive;
    }

    @NotNull
    public final MarkdownFile getFile() {
        return this.file;
    }

    @Nullable
    public final MarkdownFile getPreviousFile() {
        return this.previousFile;
    }

    @NotNull
    public final MarkdownFile getOverviewFile() {
        return this.overviewFile;
    }

    @Nullable
    public final MarkdownFile getNextFile() {
        return this.nextFile;
    }

    private NavigationDirective(RawMarkdownDirective directive, MarkdownFile file, MarkdownFile previousFile, MarkdownFile overviewFile, MarkdownFile nextFile) {
        this.directive = directive;
        this.file = file;
        this.previousFile = previousFile;
        this.overviewFile = overviewFile;
        this.nextFile = nextFile;
    }

    static {
        Companion = new Companion(null);
        NAV_TAG = new DirectiveTag("Nav");
    }

    public /* synthetic */ NavigationDirective(RawMarkdownDirective directive, MarkdownFile file, MarkdownFile previousFile, MarkdownFile overviewFile, MarkdownFile nextFile, DefaultConstructorMarker $constructor_marker) {
        this(directive, file, previousFile, overviewFile, nextFile);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lde/quantummaid/documaid/domain/markdown/navigation/NavigationDirective$Companion;", "", "()V", "NAV_TAG", "Lde/quantummaid/documaid/domain/markdown/DirectiveTag;", "getNAV_TAG", "()Lde/quantummaid/documaid/domain/markdown/DirectiveTag;", "create", "Lde/quantummaid/documaid/domain/markdown/navigation/NavigationDirective;", "rawMarkdownDirective", "Lde/quantummaid/documaid/domain/markdown/RawMarkdownDirective;", "file", "Lde/quantummaid/documaid/domain/markdown/MarkdownFile;", "project", "Lde/quantummaid/documaid/collecting/structure/Project;", "documaid"})
    public static final class Companion {
        @NotNull
        public final DirectiveTag getNAV_TAG() {
            return NAV_TAG;
        }

        @NotNull
        public final NavigationDirective create(@NotNull RawMarkdownDirective rawMarkdownDirective, @NotNull MarkdownFile file, @NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)rawMarkdownDirective, (String)"rawMarkdownDirective");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            TableOfContentsLookupData tableOfContentsLookupData = project.getInformation(TableOfContentsLookupData.Companion.getTOC_LOOKUP_KEY());
            TableOfContents tableOfContents = tableOfContentsLookupData.getTableOfContents();
            MarkdownFile overviewFile = tableOfContents.getFileWithToc();
            MarkdownFile previousFile = tableOfContents.getFilePredecessor(file);
            MarkdownFile nextFile = tableOfContents.getFileSuccessor(file);
            return new NavigationDirective(rawMarkdownDirective, file, previousFile, overviewFile, nextFile, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

