/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.domain.markdown.link;

import de.quantummaid.documaid.domain.markdown.MarkdownFile;
import de.quantummaid.documaid.domain.markdown.RawMarkdownDirective;
import de.quantummaid.documaid.domain.markdown.link.LinkDirective;
import de.quantummaid.documaid.errors.DocuMaidException;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lde/quantummaid/documaid/domain/markdown/link/LinkDirectiveOptions;", "", "rootDirRelativePath", "Ljava/nio/file/Path;", "originalPathString", "", "name", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getOriginalPathString", "getRootDirRelativePath", "()Ljava/nio/file/Path;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "documaid"})
public final class LinkDirectiveOptions {
    @NotNull
    private final Path rootDirRelativePath;
    @NotNull
    private final String originalPathString;
    @NotNull
    private final String name;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Path getRootDirRelativePath() {
        return this.rootDirRelativePath;
    }

    @NotNull
    public final String getOriginalPathString() {
        return this.originalPathString;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public LinkDirectiveOptions(@NotNull Path rootDirRelativePath, @NotNull String originalPathString, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)rootDirRelativePath, (String)"rootDirRelativePath");
        Intrinsics.checkParameterIsNotNull((Object)originalPathString, (String)"originalPathString");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.rootDirRelativePath = rootDirRelativePath;
        this.originalPathString = originalPathString;
        this.name = name;
    }

    @NotNull
    public final Path component1() {
        return this.rootDirRelativePath;
    }

    @NotNull
    public final String component2() {
        return this.originalPathString;
    }

    @NotNull
    public final String component3() {
        return this.name;
    }

    @NotNull
    public final LinkDirectiveOptions copy(@NotNull Path rootDirRelativePath, @NotNull String originalPathString, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)rootDirRelativePath, (String)"rootDirRelativePath");
        Intrinsics.checkParameterIsNotNull((Object)originalPathString, (String)"originalPathString");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return new LinkDirectiveOptions(rootDirRelativePath, originalPathString, name);
    }

    public static /* synthetic */ LinkDirectiveOptions copy$default(LinkDirectiveOptions linkDirectiveOptions, Path path, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            path = linkDirectiveOptions.rootDirRelativePath;
        }
        if ((n & 2) != 0) {
            string = linkDirectiveOptions.originalPathString;
        }
        if ((n & 4) != 0) {
            string2 = linkDirectiveOptions.name;
        }
        return linkDirectiveOptions.copy(path, string, string2);
    }

    @NotNull
    public String toString() {
        return "LinkDirectiveOptions(rootDirRelativePath=" + this.rootDirRelativePath + ", originalPathString=" + this.originalPathString + ", name=" + this.name + ")";
    }

    public int hashCode() {
        Path path = this.rootDirRelativePath;
        String string = this.originalPathString;
        String string2 = this.name;
        return ((path != null ? ((Object)path).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof LinkDirectiveOptions)) break block3;
                LinkDirectiveOptions linkDirectiveOptions = (LinkDirectiveOptions)object;
                if (!Intrinsics.areEqual((Object)this.rootDirRelativePath, (Object)linkDirectiveOptions.rootDirRelativePath) || !Intrinsics.areEqual((Object)this.originalPathString, (Object)linkDirectiveOptions.originalPathString) || !Intrinsics.areEqual((Object)this.name, (Object)linkDirectiveOptions.name)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lde/quantummaid/documaid/domain/markdown/link/LinkDirectiveOptions$Companion;", "", "()V", "create", "Lde/quantummaid/documaid/domain/markdown/link/LinkDirectiveOptions;", "directive", "Lde/quantummaid/documaid/domain/markdown/RawMarkdownDirective;", "file", "Lde/quantummaid/documaid/domain/markdown/MarkdownFile;", "documaid"})
    public static final class Companion {
        @NotNull
        public final LinkDirectiveOptions create(@NotNull RawMarkdownDirective directive, @NotNull MarkdownFile file) {
            Intrinsics.checkParameterIsNotNull((Object)directive, (String)"directive");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            String string = " *\\(?[\\s]*(?<path>[^ ]*)[\\s]*(?<name>([\\w]*|\"[^\"]*\"))[\\s]*\\)? *";
            boolean bl = false;
            Regex optionsRegex = new Regex(string);
            String options = directive.getOptionsString().getValue();
            MatchResult matchResult = optionsRegex.matchEntire((CharSequence)options);
            if (matchResult != null) {
                String name;
                MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)"path");
                if (matchGroup == null) {
                    Intrinsics.throwNpe();
                }
                String pathString = matchGroup.getValue();
                Path path = Paths.get(pathString, new String[0]);
                Path directory = file.absolutePath().getParent();
                Path absolutePath = directory.resolve(path).normalize().toAbsolutePath();
                MatchGroup matchGroup2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)"name");
                if (matchGroup2 == null) {
                    Intrinsics.throwNpe();
                }
                if (StringsKt.startsWith$default((String)(name = matchGroup2.getValue()), (String)"\"", (boolean)false, (int)2, null)) {
                    String string2 = name;
                    int n = 1;
                    int n2 = name.length() - 1;
                    boolean bl2 = false;
                    String string3 = string2;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.substring(n, n2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    name = string4;
                }
                Path path2 = absolutePath;
                Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"absolutePath");
                return new LinkDirectiveOptions(path2, pathString, name);
            }
            throw (Throwable)DocuMaidException.Companion.create("Found [" + LinkDirective.Companion.getLINK_TAG() + "] directive with not parsable options '" + directive.getCompleteString() + '\'', file);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

