/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.domain.markdown.codeSnippet;

import de.quantummaid.documaid.domain.markdown.MarkdownFile;
import de.quantummaid.documaid.domain.markdown.RawMarkdownDirective;
import de.quantummaid.documaid.domain.markdown.codeSnippet.CodeSnippetDirective;
import de.quantummaid.documaid.domain.snippet.SnippetId;
import de.quantummaid.documaid.errors.DocuMaidException;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lde/quantummaid/documaid/domain/markdown/codeSnippet/CodeSnippetDirectiveOptions;", "", "snippetId", "Lde/quantummaid/documaid/domain/snippet/SnippetId;", "filePath", "Ljava/nio/file/Path;", "(Lde/quantummaid/documaid/domain/snippet/SnippetId;Ljava/nio/file/Path;)V", "getFilePath", "()Ljava/nio/file/Path;", "getSnippetId", "()Lde/quantummaid/documaid/domain/snippet/SnippetId;", "Companion", "documaid"})
public final class CodeSnippetDirectiveOptions {
    @Nullable
    private final SnippetId snippetId;
    @Nullable
    private final Path filePath;
    @NotNull
    private static final Regex OPTIONS_WITH_SNIPPET_ID_REGEX;
    @NotNull
    private static final Regex OPTIONS_WITH_FILE;
    public static final Companion Companion;

    @Nullable
    public final SnippetId getSnippetId() {
        return this.snippetId;
    }

    @Nullable
    public final Path getFilePath() {
        return this.filePath;
    }

    public CodeSnippetDirectiveOptions(@Nullable SnippetId snippetId, @Nullable Path filePath) {
        this.snippetId = snippetId;
        this.filePath = filePath;
    }

    static {
        Companion = new Companion(null);
        String string = " *\\(? *(?<id>[\\w]*) *\\)? *";
        boolean bl = false;
        OPTIONS_WITH_SNIPPET_ID_REGEX = new Regex(string);
        string = " *\\(? *file=(?<filePath>[^ )]+) *\\)? *";
        bl = false;
        OPTIONS_WITH_FILE = new Regex(string);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lde/quantummaid/documaid/domain/markdown/codeSnippet/CodeSnippetDirectiveOptions$Companion;", "", "()V", "OPTIONS_WITH_FILE", "Lkotlin/text/Regex;", "getOPTIONS_WITH_FILE", "()Lkotlin/text/Regex;", "OPTIONS_WITH_SNIPPET_ID_REGEX", "getOPTIONS_WITH_SNIPPET_ID_REGEX", "create", "Lde/quantummaid/documaid/domain/markdown/codeSnippet/CodeSnippetDirectiveOptions;", "directive", "Lde/quantummaid/documaid/domain/markdown/RawMarkdownDirective;", "file", "Lde/quantummaid/documaid/domain/markdown/MarkdownFile;", "documaid"})
    public static final class Companion {
        @NotNull
        public final Regex getOPTIONS_WITH_SNIPPET_ID_REGEX() {
            return OPTIONS_WITH_SNIPPET_ID_REGEX;
        }

        @NotNull
        public final Regex getOPTIONS_WITH_FILE() {
            return OPTIONS_WITH_FILE;
        }

        @NotNull
        public final CodeSnippetDirectiveOptions create(@NotNull RawMarkdownDirective directive, @NotNull MarkdownFile file) {
            Intrinsics.checkParameterIsNotNull((Object)directive, (String)"directive");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            String options = directive.getOptionsString().getValue();
            MatchResult matchResult = this.getOPTIONS_WITH_SNIPPET_ID_REGEX().matchEntire((CharSequence)options);
            if (matchResult != null) {
                MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)"id");
                if (matchGroup == null) {
                    Intrinsics.throwNpe();
                }
                SnippetId snippetId = new SnippetId(matchGroup.getValue());
                return new CodeSnippetDirectiveOptions(snippetId, null);
            }
            MatchResult matchResult2 = this.getOPTIONS_WITH_FILE().matchEntire((CharSequence)options);
            if (matchResult2 != null) {
                MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2.getGroups(), (String)"filePath");
                if (matchGroup == null) {
                    Intrinsics.throwNpe();
                }
                String filePathString = matchGroup.getValue();
                Path filePath = Paths.get(filePathString, new String[0]);
                return new CodeSnippetDirectiveOptions(null, filePath);
            }
            throw (Throwable)DocuMaidException.Companion.create("Found [" + CodeSnippetDirective.Companion.getCODE_SNIPPET_TAG() + "] tag with not parsable options '" + directive.getCompleteString() + '\'', file);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

