/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.preparing.navigation;

import de.quantummaid.documaid.collecting.structure.Directory;
import de.quantummaid.documaid.collecting.structure.FileObject;
import de.quantummaid.documaid.collecting.structure.Project;
import de.quantummaid.documaid.collecting.structure.ProjectFile;
import de.quantummaid.documaid.domain.markdown.MarkdownFile;
import de.quantummaid.documaid.domain.markdown.RawMarkdownDirective;
import de.quantummaid.documaid.domain.markdown.navigation.NavigationDirective;
import de.quantummaid.documaid.domain.markdown.tableOfContents.TableOfContentsDirective;
import de.quantummaid.documaid.domain.tableOfContents.TableOfContents;
import de.quantummaid.documaid.errors.VerificationError;
import de.quantummaid.documaid.preparing.PreparingVisitor;
import de.quantummaid.documaid.preparing.tableOfContents.TableOfContentsLookupData;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lde/quantummaid/documaid/preparing/navigation/NavigationPreparer;", "Lde/quantummaid/documaid/preparing/PreparingVisitor;", "()V", "filesWithNavigationDirective", "", "Ljava/nio/file/Path;", "Lde/quantummaid/documaid/domain/markdown/MarkdownFile;", "finishPreparation", "", "Lde/quantummaid/documaid/errors/VerificationError;", "project", "Lde/quantummaid/documaid/collecting/structure/Project;", "prepareFile", "file", "Lde/quantummaid/documaid/collecting/structure/ProjectFile;", "documaid"})
public final class NavigationPreparer
implements PreparingVisitor {
    private final Map<Path, MarkdownFile> filesWithNavigationDirective = new HashMap();

    @Override
    @NotNull
    public List<VerificationError> prepareFile(@NotNull ProjectFile file, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (file instanceof MarkdownFile) {
            List<RawMarkdownDirective> navDirectives = ((MarkdownFile)file).markdownDirectivesWithIdentifier(NavigationDirective.Companion.getNAV_TAG());
            Collection collection = navDirectives;
            boolean bl = false;
            if (!collection.isEmpty()) {
                this.filesWithNavigationDirective.put(file.absolutePath(), (MarkdownFile)file);
            }
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<VerificationError> finishPreparation(@NotNull Project project) {
        Map filesWithNavButNotIndexed;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (this.filesWithNavigationDirective.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        TableOfContentsLookupData tableOfContentsLookupData = project.getInformation(TableOfContentsLookupData.Companion.getTOC_LOOKUP_KEY());
        if (!tableOfContentsLookupData.tableOfContentsAvailable()) {
            return CollectionsKt.listOf((Object)VerificationError.Companion.createWithoutFileOrigin("Found [" + NavigationDirective.Companion.getNAV_TAG() + "] tags without a [" + TableOfContentsDirective.Companion.getTOC_TAG() + ']'));
        }
        TableOfContents tableOfContents = tableOfContentsLookupData.getTableOfContents();
        List<Path> filePathsIncludedInToc = tableOfContents.getFilePathsIncludedInToc();
        Map map = filesWithNavButNotIndexed = MapsKt.minus(this.filesWithNavigationDirective, (Iterable)filePathsIncludedInToc);
        boolean bl = false;
        if (!map.isEmpty()) {
            void $this$mapTo$iv$iv;
            Map $this$map$iv = filesWithNavButNotIndexed;
            boolean $i$f$map = false;
            Map map2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            void var11_15 = $this$mapTo$iv$iv;
            boolean bl2 = false;
            Iterator iterator = var11_15.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv2;
                Map.Entry entry = item$iv$iv2 = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                VerificationError verificationError = VerificationError.Companion.create("Found [" + NavigationDirective.Companion.getNAV_TAG() + "] tag for file not indexed by table of contents", (FileObject)it.getValue());
                collection.add(verificationError);
            }
            return (List)destination$iv$iv;
        }
        List filesWithoutNavigationDirective = CollectionsKt.minus((Iterable)filePathsIncludedInToc, (Iterable)this.filesWithNavigationDirective.keySet());
        Collection $i$f$map = filesWithoutNavigationDirective;
        boolean $this$mapTo$iv$iv = false;
        if (!$i$f$map.isEmpty()) {
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv = filesWithoutNavigationDirective;
            boolean $i$f$map2 = false;
            Iterable destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                Path item$iv$iv2 = (Path)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl4 = false;
                VerificationError verificationError = VerificationError.Companion.createForPath("Found file indexed by table of contents but without [" + NavigationDirective.Companion.getNAV_TAG() + "] tag", (Path)it);
                collection.add(verificationError);
            }
            return (List)destination$iv$iv2;
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public void startPreparation(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        PreparingVisitor.DefaultImpls.startPreparation(this, project);
    }

    @Override
    @NotNull
    public List<VerificationError> beforeDirectoryPreparing(@NotNull Directory directory, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return PreparingVisitor.DefaultImpls.beforeDirectoryPreparing(this, directory, project);
    }

    @Override
    @NotNull
    public List<VerificationError> afterDirectoryPreparing(@NotNull Directory directory, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return PreparingVisitor.DefaultImpls.afterDirectoryPreparing(this, directory, project);
    }
}

