/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.domain.unclassifiedFile;

import de.quantummaid.documaid.collecting.structure.FileType;
import de.quantummaid.documaid.collecting.structure.Project;
import de.quantummaid.documaid.collecting.structure.ProjectFile;
import de.quantummaid.documaid.domain.snippet.RawSnippet;
import de.quantummaid.documaid.domain.snippet.RawSnippetExtractor;
import de.quantummaid.documaid.domain.snippet.SnippetId;
import de.quantummaid.documaid.errors.VerificationError;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u001d\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u0003H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lde/quantummaid/documaid/domain/unclassifiedFile/UnclassifiedFile;", "Lde/quantummaid/documaid/collecting/structure/ProjectFile;", "path", "Ljava/nio/file/Path;", "snippets", "", "Lde/quantummaid/documaid/domain/snippet/RawSnippet;", "(Ljava/nio/file/Path;Ljava/util/List;)V", "getSnippets", "()Ljava/util/List;", "absolutePath", "fileType", "Lde/quantummaid/documaid/collecting/structure/FileType;", "generate", "Lde/quantummaid/documaid/errors/VerificationError;", "project", "Lde/quantummaid/documaid/collecting/structure/Project;", "validate", "Companion", "documaid"})
public final class UnclassifiedFile
implements ProjectFile {
    private final Path path;
    @NotNull
    private final List<RawSnippet> snippets;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public FileType fileType() {
        return FileType.OTHER;
    }

    @Override
    @NotNull
    public Path absolutePath() {
        return this.path;
    }

    @Override
    @NotNull
    public List<VerificationError> generate(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public List<VerificationError> validate(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public List<RawSnippet> snippets() {
        return this.snippets;
    }

    @NotNull
    public final List<RawSnippet> getSnippets() {
        return this.snippets;
    }

    private UnclassifiedFile(Path path, List<? extends RawSnippet> snippets) {
        this.path = path;
        this.snippets = snippets;
    }

    @Override
    @NotNull
    public RawSnippet snippetForId(@NotNull SnippetId snippetId) {
        Intrinsics.checkParameterIsNotNull((Object)snippetId, (String)"snippetId");
        return ProjectFile.DefaultImpls.snippetForId(this, snippetId);
    }

    @Override
    @NotNull
    public String name() {
        return ProjectFile.DefaultImpls.name(this);
    }

    public /* synthetic */ UnclassifiedFile(Path path, List snippets, DefaultConstructorMarker $constructor_marker) {
        this(path, snippets);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lde/quantummaid/documaid/domain/unclassifiedFile/UnclassifiedFile$Companion;", "", "()V", "create", "Lde/quantummaid/documaid/domain/unclassifiedFile/UnclassifiedFile;", "path", "Ljava/nio/file/Path;", "UnclassifiedSnippetFormat", "documaid"})
    public static final class Companion {
        @NotNull
        public final UnclassifiedFile create(@NotNull Path path) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            List<RawSnippet> snippets = RawSnippetExtractor.Companion.extractSnippets(path, UnclassifiedSnippetFormat.INSTANCE.getRegex());
            return new UnclassifiedFile(path, snippets, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lde/quantummaid/documaid/domain/unclassifiedFile/UnclassifiedFile$Companion$UnclassifiedSnippetFormat;", "", "()V", "endTagRegex", "", "regex", "Lkotlin/text/Regex;", "getRegex", "()Lkotlin/text/Regex;", "startTagRegex", "documaid"})
        public static final class UnclassifiedSnippetFormat {
            private static final String startTagRegex = "<!-- *Showcase *start *(?<id>\\w+) *--> *\\n";
            private static final String endTagRegex = " *<!-- *Showcase *end *\\k<id> *--> *";
            @NotNull
            private static final Regex regex;
            public static final UnclassifiedSnippetFormat INSTANCE;

            @NotNull
            public final Regex getRegex() {
                return regex;
            }

            private UnclassifiedSnippetFormat() {
            }

            static {
                UnclassifiedSnippetFormat unclassifiedSnippetFormat;
                INSTANCE = unclassifiedSnippetFormat = new UnclassifiedSnippetFormat();
                regex = new Regex("(?s)<!-- *Showcase *start *(?<id>\\w+) *--> *\\n(?<snippet>.*(?= *<!-- *Showcase *end *\\k<id> *--> *)) *<!-- *Showcase *end *\\k<id> *--> *\\n");
            }
        }
    }
}

