/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.domain.navigation;

import de.quantummaid.documaid.domain.markdown.MarkdownFile;
import de.quantummaid.documaid.domain.markdown.RemainingMarkupFileContent;
import de.quantummaid.documaid.domain.markdown.link.LinkMarkdown;
import de.quantummaid.documaid.domain.markdown.matching.TrailingMarkdownMatchResult;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u000eH\u0002J\b\u0010\u0010\u001a\u00020\u000eH\u0002J\b\u0010\u0011\u001a\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0013"}, d2={"Lde/quantummaid/documaid/domain/navigation/NavigationMarkdown;", "", "fileWithDirective", "Lde/quantummaid/documaid/domain/markdown/MarkdownFile;", "previousFile", "overviewFile", "nextFile", "(Lde/quantummaid/documaid/domain/markdown/MarkdownFile;Lde/quantummaid/documaid/domain/markdown/MarkdownFile;Lde/quantummaid/documaid/domain/markdown/MarkdownFile;Lde/quantummaid/documaid/domain/markdown/MarkdownFile;)V", "getFileWithDirective", "()Lde/quantummaid/documaid/domain/markdown/MarkdownFile;", "getNextFile", "getOverviewFile", "getPreviousFile", "generateMarkdown", "", "nextFileLink", "overviewLink", "previousFileLink", "Companion", "documaid"})
public final class NavigationMarkdown {
    @NotNull
    private final MarkdownFile fileWithDirective;
    @Nullable
    private final MarkdownFile previousFile;
    @NotNull
    private final MarkdownFile overviewFile;
    @Nullable
    private final MarkdownFile nextFile;
    @NotNull
    private static final Regex NAV_MARKDOWN_REGEX;
    public static final Companion Companion;

    @NotNull
    public final String generateMarkdown() {
        return this.previousFileLink() + this.overviewLink() + this.nextFileLink();
    }

    private final String previousFileLink() {
        String string;
        if (this.previousFile != null) {
            Path relativePath = this.fileWithDirective.absolutePath().getParent().relativize(this.previousFile.absolutePath());
            LinkMarkdown linkMarkdown = new LinkMarkdown("&larr;", ((Object)relativePath).toString());
            string = linkMarkdown.markdownString() + "&nbsp;&nbsp;&nbsp;";
        } else {
            string = "";
        }
        return string;
    }

    private final String overviewLink() {
        Path relativePath = this.fileWithDirective.absolutePath().getParent().relativize(this.overviewFile.absolutePath());
        LinkMarkdown linkMarkdown = new LinkMarkdown("Overview", ((Object)relativePath).toString());
        return linkMarkdown.markdownString();
    }

    private final String nextFileLink() {
        String string;
        if (this.nextFile != null) {
            Path relativePath = this.fileWithDirective.absolutePath().getParent().relativize(this.nextFile.absolutePath());
            LinkMarkdown linkMarkdown = new LinkMarkdown("&rarr;", ((Object)relativePath).toString());
            string = "&nbsp;&nbsp;&nbsp;" + linkMarkdown.markdownString();
        } else {
            string = "";
        }
        return string;
    }

    @NotNull
    public final MarkdownFile getFileWithDirective() {
        return this.fileWithDirective;
    }

    @Nullable
    public final MarkdownFile getPreviousFile() {
        return this.previousFile;
    }

    @NotNull
    public final MarkdownFile getOverviewFile() {
        return this.overviewFile;
    }

    @Nullable
    public final MarkdownFile getNextFile() {
        return this.nextFile;
    }

    public NavigationMarkdown(@NotNull MarkdownFile fileWithDirective, @Nullable MarkdownFile previousFile, @NotNull MarkdownFile overviewFile, @Nullable MarkdownFile nextFile) {
        Intrinsics.checkParameterIsNotNull((Object)fileWithDirective, (String)"fileWithDirective");
        Intrinsics.checkParameterIsNotNull((Object)overviewFile, (String)"overviewFile");
        this.fileWithDirective = fileWithDirective;
        this.previousFile = previousFile;
        this.overviewFile = overviewFile;
        this.nextFile = nextFile;
    }

    static {
        Companion = new Companion(null);
        String string = "\\n? *(\\[&larr;]\\([^)]+\\)&nbsp;&nbsp;&nbsp;)?\\[Overview]\\([^)]+\\)(&nbsp;&nbsp;&nbsp;\\[&rarr;]\\([^)]+\\))?";
        boolean bl = false;
        NAV_MARKDOWN_REGEX = new Regex(string);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lde/quantummaid/documaid/domain/navigation/NavigationMarkdown$Companion;", "", "()V", "NAV_MARKDOWN_REGEX", "Lkotlin/text/Regex;", "getNAV_MARKDOWN_REGEX", "()Lkotlin/text/Regex;", "startsWithNavigationMarkdown", "Lde/quantummaid/documaid/domain/markdown/matching/TrailingMarkdownMatchResult;", "remainingMarkupFileContent", "Lde/quantummaid/documaid/domain/markdown/RemainingMarkupFileContent;", "documaid"})
    public static final class Companion {
        @NotNull
        public final Regex getNAV_MARKDOWN_REGEX() {
            return NAV_MARKDOWN_REGEX;
        }

        @NotNull
        public final TrailingMarkdownMatchResult startsWithNavigationMarkdown(@NotNull RemainingMarkupFileContent remainingMarkupFileContent) {
            String content;
            Intrinsics.checkParameterIsNotNull((Object)remainingMarkupFileContent, (String)"remainingMarkupFileContent");
            String string = content = remainingMarkupFileContent.getContent();
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            if (!StringsKt.startsWith$default((String)((Object)StringsKt.trimStart((CharSequence)string2)).toString(), (String)"[", (boolean)false, (int)2, null)) {
                return TrailingMarkdownMatchResult.Companion.createForNoMatch();
            }
            MatchResult matchResult = Regex.find$default((Regex)this.getNAV_MARKDOWN_REGEX(), (CharSequence)content, (int)0, (int)2, null);
            return matchResult != null ? TrailingMarkdownMatchResult.Companion.createForMatch(matchResult.getRange().getLast() - matchResult.getRange().getStart(), matchResult.getValue()) : TrailingMarkdownMatchResult.Companion.createForNoMatch();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

