/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.domain.markdown.link;

import de.quantummaid.documaid.collecting.structure.Project;
import de.quantummaid.documaid.domain.markdown.MarkdownFile;
import de.quantummaid.documaid.domain.markdown.MarkdownReplacement;
import de.quantummaid.documaid.domain.markdown.MarkdownTagHandler;
import de.quantummaid.documaid.domain.markdown.RawMarkdownDirective;
import de.quantummaid.documaid.domain.markdown.link.LinkDirective;
import de.quantummaid.documaid.domain.markdown.link.LinkMarkdown;
import de.quantummaid.documaid.domain.markdown.matching.TrailingMarkdownMatchResult;
import de.quantummaid.documaid.errors.VerificationError;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\u001c\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00150\u00042\u0006\u0010\u0010\u001a\u00020\tH\u0002J&\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0017"}, d2={"Lde/quantummaid/documaid/domain/markdown/link/LinkMarkdownTagHandler;", "Lde/quantummaid/documaid/domain/markdown/MarkdownTagHandler;", "()V", "generate", "Lkotlin/Pair;", "Lde/quantummaid/documaid/domain/markdown/MarkdownReplacement;", "", "Lde/quantummaid/documaid/errors/VerificationError;", "directive", "Lde/quantummaid/documaid/domain/markdown/RawMarkdownDirective;", "file", "Lde/quantummaid/documaid/domain/markdown/MarkdownFile;", "project", "Lde/quantummaid/documaid/collecting/structure/Project;", "rangeToReplaceIn", "Lkotlin/ranges/IntRange;", "markdownDirective", "textToReplace", "", "tag", "textToBeReplaced", "Lde/quantummaid/documaid/domain/markdown/matching/TrailingMarkdownMatchResult;", "validate", "documaid"})
public final class LinkMarkdownTagHandler
implements MarkdownTagHandler {
    @Override
    @NotNull
    public String tag() {
        return LinkDirective.Companion.getLINK_TAG().toString();
    }

    @Override
    @NotNull
    public Pair<MarkdownReplacement, List<VerificationError>> generate(@NotNull RawMarkdownDirective directive, @NotNull MarkdownFile file, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)directive, (String)"directive");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        LinkDirective linkDirective = LinkDirective.Companion.create(directive, file, project);
        String markdown = linkDirective.generateMarkdown();
        Pair<String, TrailingMarkdownMatchResult> pair = this.textToBeReplaced(directive);
        String textToBeReplaced = (String)pair.component1();
        IntRange rangeToReplaceIn = this.rangeToReplaceIn(directive, markdown);
        MarkdownReplacement markdownReplacement = new MarkdownReplacement(rangeToReplaceIn, textToBeReplaced, markdown);
        return new Pair((Object)markdownReplacement, (Object)CollectionsKt.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<VerificationError> validate(@NotNull RawMarkdownDirective directive, @NotNull MarkdownFile file, @NotNull Project project) {
        boolean trailingCodeFound;
        void textToBeReplaced;
        Intrinsics.checkParameterIsNotNull((Object)directive, (String)"directive");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        LinkDirective linkDirective = LinkDirective.Companion.create(directive, file, project);
        String markdown = linkDirective.generateMarkdown();
        Pair<String, TrailingMarkdownMatchResult> pair = this.textToBeReplaced(directive);
        String string = (String)pair.component1();
        TrailingMarkdownMatchResult trailingMarkdownMatchResult = (TrailingMarkdownMatchResult)pair.component2();
        return Intrinsics.areEqual((Object)textToBeReplaced, (Object)markdown) ^ true ? ((trailingCodeFound = trailingMarkdownMatchResult.getMatches()) ? CollectionsKt.listOf((Object)VerificationError.Companion.create("Found [" + this.tag() + "] tag with wrong link being set: '" + directive.getCompleteString() + '\'', file)) : CollectionsKt.listOf((Object)VerificationError.Companion.create("Found [" + this.tag() + "] tag without link being set for '" + directive.getCompleteString() + '\'', file))) : CollectionsKt.emptyList();
    }

    private final Pair<String, TrailingMarkdownMatchResult> textToBeReplaced(RawMarkdownDirective markdownDirective) {
        TrailingMarkdownMatchResult markdownMatchResult = LinkMarkdown.Companion.startsWithLinkMarkdown(markdownDirective.getRemainingMarkupFileContent());
        String text = markdownMatchResult.getMatches() ? markdownDirective.getCompleteString() + markdownMatchResult.getContent() : markdownDirective.getCompleteString();
        return new Pair((Object)text, (Object)markdownMatchResult);
    }

    private final IntRange rangeToReplaceIn(RawMarkdownDirective markdownDirective, String textToReplace) {
        int startIndex = markdownDirective.getRange().getFirst();
        int endIndexInitialTag = markdownDirective.getRange().getLast();
        int lengthNewContent = textToReplace.length();
        return new IntRange(startIndex, Math.max(endIndexInitialTag, startIndex + lengthNewContent));
    }
}

