/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.collecting;

import de.quantummaid.documaid.collecting.structure.Directory;
import de.quantummaid.documaid.collecting.structure.FileCreator;
import de.quantummaid.documaid.collecting.structure.FileObjectVisitor;
import de.quantummaid.documaid.collecting.structure.ProjectFile;
import de.quantummaid.documaid.collecting.traversaldecision.CollectingTraversalDecision;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0010\u001a\u00020\rJ\u001c\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00022\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u001c\u0010\u0016\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00022\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u001c\u0010\u0019\u001a\u00020\u00122\b\u0010\u001a\u001a\u0004\u0018\u00010\u00022\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lde/quantummaid/documaid/collecting/CollectingFileVisitor;", "Ljava/nio/file/SimpleFileVisitor;", "", "visitors", "", "Lde/quantummaid/documaid/collecting/structure/FileObjectVisitor;", "collectingTraversalDecision", "Lde/quantummaid/documaid/collecting/traversaldecision/CollectingTraversalDecision;", "(Ljava/util/List;Lde/quantummaid/documaid/collecting/traversaldecision/CollectingTraversalDecision;)V", "getCollectingTraversalDecision", "()Lde/quantummaid/documaid/collecting/traversaldecision/CollectingTraversalDecision;", "currentDirectoryStack", "", "Lde/quantummaid/documaid/collecting/structure/Directory;", "getVisitors", "()Ljava/util/List;", "getRootDirectory", "postVisitDirectory", "Ljava/nio/file/FileVisitResult;", "dir", "exc", "Ljava/io/IOException;", "preVisitDirectory", "attrs", "Ljava/nio/file/attribute/BasicFileAttributes;", "visitFile", "file", "documaid"})
final class CollectingFileVisitor
extends SimpleFileVisitor<Object> {
    private final List<Directory> currentDirectoryStack;
    @NotNull
    private final List<FileObjectVisitor> visitors;
    @NotNull
    private final CollectingTraversalDecision collectingTraversalDecision;

    @Override
    @NotNull
    public FileVisitResult preVisitDirectory(@Nullable Object dir, @Nullable BasicFileAttributes attrs) {
        Path path;
        super.preVisitDirectory(dir, attrs);
        Path path2 = path = Paths.get(String.valueOf(dir), new String[0]).toAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"path");
        if (!this.collectingTraversalDecision.shouldDirectoryBeVisited(path2)) {
            return FileVisitResult.SKIP_SUBTREE;
        }
        Directory directory = new Directory(path);
        Collection collection = this.currentDirectoryStack;
        boolean bl = false;
        if (!collection.isEmpty()) {
            Directory parentDirectory = (Directory)CollectionsKt.last(this.currentDirectoryStack);
            parentDirectory.addChild(directory);
        }
        this.currentDirectoryStack.add(directory);
        return FileVisitResult.CONTINUE;
    }

    @Override
    @NotNull
    public FileVisitResult visitFile(@Nullable Object file, @Nullable BasicFileAttributes attrs) {
        Path path;
        super.visitFile(file, attrs);
        Path path2 = path = Paths.get(String.valueOf(file), new String[0]).toAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"path");
        if (!this.collectingTraversalDecision.shouldFileBeVisited(path2)) {
            return FileVisitResult.CONTINUE;
        }
        Directory directory = (Directory)CollectionsKt.last(this.currentDirectoryStack);
        ProjectFile fileObject = FileCreator.Companion.create(path);
        directory.addChild(fileObject);
        Iterable $this$forEach$iv = this.visitors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileObjectVisitor it = (FileObjectVisitor)element$iv;
            boolean bl = false;
            it.fileVisited(fileObject);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    @NotNull
    public FileVisitResult postVisitDirectory(@Nullable Object dir, @Nullable IOException exc) {
        super.postVisitDirectory(dir, exc);
        Directory directory = (Directory)CollectionsKt.last(this.currentDirectoryStack);
        if (this.currentDirectoryStack.size() > 1) {
            this.currentDirectoryStack.remove(CollectionsKt.getLastIndex(this.currentDirectoryStack));
        }
        Iterable $this$forEach$iv = this.visitors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileObjectVisitor it = (FileObjectVisitor)element$iv;
            boolean bl = false;
            it.directoryVisited(directory);
        }
        return FileVisitResult.CONTINUE;
    }

    @NotNull
    public final Directory getRootDirectory() {
        return (Directory)CollectionsKt.first(this.currentDirectoryStack);
    }

    @NotNull
    public final List<FileObjectVisitor> getVisitors() {
        return this.visitors;
    }

    @NotNull
    public final CollectingTraversalDecision getCollectingTraversalDecision() {
        return this.collectingTraversalDecision;
    }

    public CollectingFileVisitor(@NotNull List<? extends FileObjectVisitor> visitors, @NotNull CollectingTraversalDecision collectingTraversalDecision) {
        List list;
        Intrinsics.checkParameterIsNotNull(visitors, (String)"visitors");
        Intrinsics.checkParameterIsNotNull((Object)collectingTraversalDecision, (String)"collectingTraversalDecision");
        this.visitors = visitors;
        this.collectingTraversalDecision = collectingTraversalDecision;
        CollectingFileVisitor collectingFileVisitor = this;
        boolean bl = false;
        collectingFileVisitor.currentDirectoryStack = list = (List)new ArrayList();
    }
}

