/*
 * Decompiled with CFR 0.152.
 */
package de.qaware.tools.sqbb.library.impl;

import de.qaware.tools.sqbb.library.api.BuildBreaker;
import de.qaware.tools.sqbb.library.api.connector.Authentication;
import de.qaware.tools.sqbb.library.impl.BuildBreakerImpl;
import de.qaware.tools.sqbb.library.impl.connector.SonarQubeConnectorImpl;
import de.qaware.tools.sqbb.library.impl.http.ApacheHttpClient;
import java.time.Duration;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public final class BuildBreakerFactory {
    private BuildBreakerFactory() {
    }

    public static CloseableBuildBreaker create(Duration waitTime, String baseUrl, Authentication authentication) {
        final CloseableHttpClient httpClient = HttpClients.createDefault();
        SonarQubeConnectorImpl sonarQubeConnector = new SonarQubeConnectorImpl(new ApacheHttpClient(httpClient), baseUrl, authentication);
        final BuildBreakerImpl buildBreaker = new BuildBreakerImpl(waitTime, sonarQubeConnector);
        return new CloseableBuildBreaker(){

            @Override
            public BuildBreaker get() {
                return buildBreaker;
            }

            @Override
            public void close() throws Exception {
                httpClient.close();
            }
        };
    }

    public static interface CloseableBuildBreaker
    extends AutoCloseable {
        public BuildBreaker get();
    }
}

