/*
 * Decompiled with CFR 0.152.
 */
package de.qaware.tools.sqbb.cli;

import ch.qos.logback.classic.Level;
import de.qaware.tools.sqbb.cli.commandline.CommandLineOptions;
import de.qaware.tools.sqbb.cli.commandline.Parser;
import de.qaware.tools.sqbb.library.api.BreakBuildException;
import de.qaware.tools.sqbb.library.api.connector.Authentication;
import de.qaware.tools.sqbb.library.impl.BuildBreakerFactory;
import java.time.Duration;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cli {
    private static final Logger LOGGER = LoggerFactory.getLogger(Cli.class);
    private static final int EXIT_CODE_SUCCESS = 0;
    private static final int EXIT_CODE_FAILURE = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) {
        CommandLineOptions commandLine;
        Parser parser = new Parser();
        try {
            commandLine = parser.parse(args);
        }
        catch (ParseException e) {
            LOGGER.debug("Caught ParseException", e);
            System.out.println("Invocation failed: " + e.getMessage());
            parser.printHelp();
            System.exit(1);
            return;
        }
        if (commandLine.isDebug()) {
            Cli.enableDebugMode();
        }
        LOGGER.debug("Started with command line {}", (Object)commandLine);
        boolean ok = false;
        try {
            new Cli().run(commandLine);
            ok = true;
            LOGGER.debug("Stopped");
            System.exit(ok ? 0 : 1);
        }
        catch (BreakBuildException e) {
            LOGGER.error("Build broken! Reason: {}", (Object)e.getMessage());
            LOGGER.debug("Exception details", e);
            LOGGER.debug("Stopped");
            System.exit(ok ? 0 : 1);
        }
        catch (Exception e2) {
            LOGGER.error("Boom goes the program", e2);
            LOGGER.debug("Stopped");
            System.exit(ok ? 0 : 1);
            {
                catch (Throwable throwable) {
                    LOGGER.debug("Stopped");
                    System.exit(ok ? 0 : 1);
                    throw throwable;
                }
            }
        }
    }

    private void run(CommandLineOptions commandLine) throws Exception {
        Authentication authentication = this.getAuthentication();
        String baseUrl = this.getBaseUrl();
        try (BuildBreakerFactory.CloseableBuildBreaker buildBreaker = BuildBreakerFactory.create(Duration.ofSeconds(10L), baseUrl, authentication);){
            buildBreaker.get().breakBuildIfNeeded(commandLine.getProjectKey(), commandLine.getBranchMode());
        }
    }

    private static void enableDebugMode() {
        ch.qos.logback.classic.Logger root = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger("ROOT");
        root.setLevel(Level.TRACE);
        LOGGER.debug("Enabled debug mode");
    }

    private Authentication getAuthentication() {
        return Authentication.fromToken(this.getEnvOrFail("SONAR_TOKEN"));
    }

    private String getBaseUrl() {
        return this.getEnvOrFail("SONAR_URL");
    }

    private String getEnvOrFail(String variable) {
        String result = System.getenv(variable);
        if (result == null) {
            LOGGER.error("{} environment variable is not set", (Object)variable);
            throw new IllegalStateException(variable + " environment variable is not set");
        }
        return result;
    }
}

