/*
 * Decompiled with CFR 0.152.
 */
package de.pseudonymisierung.controlnumbers;

import de.pseudonymisierung.controlnumbers.ControlNumberGenerator;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class EncryptedControlNumberGenerator
extends ControlNumberGenerator {
    private Mac hmacMd5;
    private Mac hmacSha1;
    private Cipher aes;
    private Base64 base64;
    private String keyId;

    @Override
    protected synchronized byte[] getMd5Hash(String input) {
        return this.hmacMd5.doFinal(input.getBytes(this.encoding));
    }

    @Override
    protected synchronized byte[] getSha1Hash(String input) {
        return this.hmacSha1.doFinal(input.getBytes(this.encoding));
    }

    public static Builder builder(String passphrase) {
        return new Builder(passphrase);
    }

    public synchronized String encrypt(String value) {
        byte[] data;
        try {
            data = this.aes.doFinal(value.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("EncryptedControlNumberGenerator needs UTF8 encoding to be available.", e);
        }
        catch (Exception e) {
            throw new Error("Unexpected error while performing encryption.", e);
        }
        return this.base64.encodeAsString(data);
    }

    protected EncryptedControlNumberGenerator(Builder builder) {
        super(builder);
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] key = md5.digest(builder.passphrase.getBytes("UTF8"));
            SecretKeySpec keySpec = new SecretKeySpec(key, "HmacSHA1");
            this.hmacSha1 = Mac.getInstance("HmacSHA1");
            this.hmacSha1.init(keySpec);
            keySpec = new SecretKeySpec(key, "HmacMD5");
            this.hmacMd5 = Mac.getInstance("HmacMD5");
            this.hmacMd5.init(keySpec);
            keySpec = new SecretKeySpec(key, "AES");
            this.aes = Cipher.getInstance("AES");
            this.aes.init(1, keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("EncryptedControlNumberGenerator needs HmacSHA1 and HmacMD5 implementations to be available.", e);
        }
        catch (NoSuchPaddingException e) {
            throw new Error("Unsupported padding.", e);
        }
        catch (InvalidKeyException e) {
            throw new Error("Hashed passphrase did not yield valid key.", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
        this.base64 = new Base64();
    }

    public static class Builder
    extends ControlNumberGenerator.AbstractBuilder<EncryptedControlNumberGenerator> {
        private String passphrase;

        private Builder(String passphrase) {
            if (passphrase == null || passphrase.equals("")) {
                throw new IllegalArgumentException("Passphrase must be a valid, non-empty string.");
            }
            this.passphrase = passphrase;
        }

        @Override
        public EncryptedControlNumberGenerator build() {
            return new EncryptedControlNumberGenerator(this);
        }
    }
}

